#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-Iou9alWANX1B0LHYHls4HO
key:                  dhall-1.42.3-Iou9alWANX1B0LHYHls4HO
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  4818623a0ce4c4b97d0ddba210943674
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-Iou9alWANX1B0LHYHls4HO
depends:
    Diff-0.5-A8nvOVmSsh0JkAblhshgiC aeson-2.1.2.1-nTcMAwSjFOFbKrX5mWkol
    aeson-pretty-0.8.10-Bn3MrqKITSRGoNuV6rGApo
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    atomic-write-0.2.1.1-B8RFm8ZcjVg5XR1YxLfRJA base-4.17.2.1
    base16-bytestring-1.0.2.0-4VKZSMAQma4FWplzwntFGI
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-Dv0qc5eM6SdL4nJsx4bnK
    cborg-0.2.10.0-FuDcOKLM0s41smx838CIUm
    cborg-json-0.2.6.0-73l5jRPdEVa5SWbRWj4f3y containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-E0KRVYfuUiDIsKoA6lOQsf
    data-fix-0.3.4-CyK7pm63kET0XFa5BjIi deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-69ARLzwUZZrDFCBHrk7QZt exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-HtD0l93xk279B85CrQJJAU
    hashable-1.4.6.0-AnOmtRToJbI9DS9f6Gdy0i haskeline-0.8.2
    http-client-0.7.19-ItVvZ8PodQhKrjwqBcCUYZ
    http-client-tls-0.3.6.4-CEK6krdvlVv4rw49kLfgyN
    http-types-0.12.4-1OQw2FrAjtsGCePB2Q8s8s
    indexed-traversable-0.1.4-9hXlgoaGrHXBpvZrKSRx7V
    megaparsec-9.7.0-30CmWzNYqun9hcXpVgYg36
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-IgEz3CB1YIOEy0roDjtsJm
    optparse-applicative-0.18.1.0-3BM2XfGPAi84FVPqRQY5AK
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-83jSz45EDl73E74vH64Y3m
    pretty-simple-4.1.3.0-HaWDJgEUxKaJ0BqLHfNoXD
    prettyprinter-1.7.1-AF4Gt6IhKUy3k7s13EBNuD
    prettyprinter-ansi-terminal-1.1.3-FQisb84CsPW4gsLLZgiBMq
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-K9UnBgGB9Y7F763TSfYqCQ
    serialise-0.2.6.1-1d4B7FlhCs7BjRhTBCneqn template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-4SYfHjtWbKZ86BwKhYWrIk
    text-short-0.1.6-EVf6vrikVI7BQfpzDXdt5t
    th-lift-instances-0.1.20-7ZXde17j2tx3O74oAJXQlR time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-8OQzyIScvCNZH5Kpr8RxD
    unordered-containers-0.2.20-KDi8IgRcOV5HCm7hBAqDWV
    vector-0.13.2.0-FDZBPFjQhmHDghUn2Zh3lL

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

