/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSLCH;
import org.w3c.css.om.typed.CSSNumericValue;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class LCHColorValue
extends ColorValue
implements CSSLCH {
    private static final long serialVersionUID = 1L;
    protected NumericValue l;
    protected NumericValue c;
    protected NumericValue h;

    public LCHColorValue(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3) throws DOMSyntaxException {
        this(numericValue, numericValue2, numericValue3, SVGValueConstants.NUMBER_1);
    }

    public LCHColorValue(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3, NumericValue numericValue4) throws DOMSyntaxException {
        super(numericValue4);
        this.setL(numericValue);
        this.setC(numericValue2);
        this.setH(numericValue3);
    }

    @Override
    public String getCSSColorSpace() {
        return "lch";
    }

    public String getCssText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("lch(").append(this.l.getCssText()).append(' ').append(this.c.getCssText()).append(' ').append(this.h.getCssText());
        if (!this.isOpaque()) {
            stringBuilder.append(' ').append(this.getAlpha().getCssText());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public NumericValue getL() {
        return this.l;
    }

    public NumericValue getC() {
        return this.c;
    }

    public NumericValue getH() {
        return this.h;
    }

    public void setL(double d) {
        this.l = new FloatValue(2, (float)d);
        this.componentize(this.l);
        this.componentChanged(this.l);
    }

    public void setL(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.l = this.component(cSSNumericValue);
        this.componentChanged(this.l);
    }

    private NumericValue component(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        NumericValue numericValue = (NumericValue)cSSNumericValue;
        if (numericValue.getUnitType() != 2 && numericValue.getUnitType() != 0) {
            throw new DOMSyntaxException("LC component must be a number or percentage.");
        }
        if (numericValue.handler != null) {
            numericValue = numericValue.clone();
        }
        this.componentize(numericValue);
        return numericValue;
    }

    public void setC(double d) {
        this.c = new FloatValue(2, (float)d);
        this.componentize(this.c);
        this.componentChanged(this.c);
    }

    public void setC(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.c = this.component(cSSNumericValue);
        this.componentChanged(this.c);
    }

    public void setH(double d) {
        this.h = new FloatValue(80, (float)d);
        this.componentize(this.h);
        this.componentChanged(this.h);
    }

    public void setH(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.h = this.hueComponent(cSSNumericValue);
        this.componentChanged(this.h);
    }

    private NumericValue hueComponent(CSSNumericValue cSSNumericValue) {
        NumericValue numericValue = (NumericValue)cSSNumericValue;
        if (numericValue.getUnitType() != 0 && !CSSUnit.isAngleUnitType((short)numericValue.getUnitType())) {
            throw new DOMSyntaxException("Hue component must be a number or angle.");
        }
        if (numericValue.handler != null) {
            numericValue = numericValue.clone();
        }
        this.componentize(numericValue);
        return numericValue;
    }

    @Override
    public int getLength() throws DOMException {
        return 4;
    }

    @Override
    public Value item(int n) throws DOMException {
        switch (n) {
            case 0: {
                return this.getL();
            }
            case 1: {
                return this.getC();
            }
            case 2: {
                return this.getH();
            }
            case 3: {
                return this.getAlpha();
            }
        }
        return null;
    }

    @Override
    public LCHColorValue clone() {
        LCHColorValue lCHColorValue = (LCHColorValue)super.clone();
        lCHColorValue.l = this.l.clone();
        lCHColorValue.c = this.c.clone();
        lCHColorValue.h = this.h.clone();
        return lCHColorValue;
    }
}

