/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeJavaList
extends NativeJavaObject {
    private static final long serialVersionUID = 660285467829047519L;
    private List<Object> list;

    public NativeJavaList(Scriptable scriptable, Object object) {
        super(scriptable, object, object.getClass());
        assert (object instanceof List);
        this.list = (List)object;
    }

    @Override
    public String getClassName() {
        return "JavaList";
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        if (string.equals("length")) {
            return true;
        }
        return super.has(string, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (this.isWithValidIndex(n)) {
            return true;
        }
        return super.has(n, scriptable);
    }

    @Override
    public void delete(int n) {
        if (this.isWithValidIndex(n)) {
            this.list.set(n, null);
        }
    }

    @Override
    public boolean has(Symbol symbol, Scriptable scriptable) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(symbol)) {
            return true;
        }
        return super.has(symbol, scriptable);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        if ("length".equals(string)) {
            return this.list.size();
        }
        return super.get(string, scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (this.isWithValidIndex(n)) {
            Context context = Context.getCurrentContext();
            Object object = this.list.get(n);
            if (context != null) {
                return context.getWrapFactory().wrap(context, this, object, object == null ? null : object.getClass());
            }
            return object;
        }
        return Undefined.instance;
    }

    @Override
    public Object get(Symbol symbol, Scriptable scriptable) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(symbol)) {
            return Boolean.TRUE;
        }
        return super.get(symbol, scriptable);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (n >= 0) {
            Object object2 = Context.jsToJava(object, Object.class);
            if (n == this.list.size()) {
                this.list.add(object2);
            } else {
                this.ensureCapacity(n + 1);
                this.list.set(n, object2);
            }
            return;
        }
        super.put(n, scriptable, object);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (this.list != null && "length".equals(string)) {
            this.setLength(object);
            return;
        }
        super.put(string, scriptable, object);
    }

    private void ensureCapacity(int n) {
        if (n > this.list.size()) {
            if (this.list instanceof ArrayList) {
                ((ArrayList)this.list).ensureCapacity(n);
            }
            while (n > this.list.size()) {
                this.list.add(null);
            }
        }
    }

    private void setLength(Object object) {
        double d = ScriptRuntime.toNumber(object);
        long l = ScriptRuntime.toUint32(d);
        if ((double)l != d || l > Integer.MAX_VALUE) {
            String string = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(string);
        }
        if (l < (long)this.list.size()) {
            this.list.subList((int)l, this.list.size()).clear();
        } else {
            this.ensureCapacity((int)l);
        }
    }

    @Override
    public Object[] getIds() {
        List list = (List)this.javaObject;
        Object[] objectArray = new Object[list.size()];
        int n = list.size();
        while (--n >= 0) {
            objectArray[n] = n;
        }
        return objectArray;
    }

    private boolean isWithValidIndex(int n) {
        return n >= 0 && n < this.list.size();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

