/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.NativeRegExpInstantiator;
import org.mozilla.javascript.regexp.RegExpImpl;

class NativeRegExpCtor
extends BaseFunction {
    private static final long serialVersionUID = -5733330028285400526L;
    private static final int Id_multiline = 1;
    private static final int Id_STAR = 2;
    private static final int Id_input = 3;
    private static final int Id_UNDERSCORE = 4;
    private static final int Id_lastMatch = 5;
    private static final int Id_AMPERSAND = 6;
    private static final int Id_lastParen = 7;
    private static final int Id_PLUS = 8;
    private static final int Id_leftContext = 9;
    private static final int Id_BACK_QUOTE = 10;
    private static final int Id_rightContext = 11;
    private static final int Id_QUOTE = 12;
    private static final int DOLLAR_ID_BASE = 12;
    private static final int Id_DOLLAR_1 = 13;
    private static final int Id_DOLLAR_2 = 14;
    private static final int Id_DOLLAR_3 = 15;
    private static final int Id_DOLLAR_4 = 16;
    private static final int Id_DOLLAR_5 = 17;
    private static final int Id_DOLLAR_6 = 18;
    private static final int Id_DOLLAR_7 = 19;
    private static final int Id_DOLLAR_8 = 20;
    private static final int Id_DOLLAR_9 = 21;
    private static final int MAX_INSTANCE_ID = 21;
    private int multilineAttr = 4;
    private int starAttr = 4;
    private int inputAttr = 4;
    private int underscoreAttr = 4;

    NativeRegExpCtor() {
    }

    @Override
    public String getFunctionName() {
        return "RegExp";
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp && (objectArray.length == 1 || objectArray[1] == Undefined.instance)) {
            return objectArray[0];
        }
        return this.construct(context, scriptable, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        NativeRegExp nativeRegExp = NativeRegExpInstantiator.withLanguageVersion(context.getLanguageVersion());
        nativeRegExp.compile(context, scriptable, objectArray);
        ScriptRuntime.setBuiltinProtoAndParent(nativeRegExp, scriptable, TopLevel.Builtins.RegExp);
        return nativeRegExp;
    }

    private static RegExpImpl getImpl() {
        Context context = Context.getCurrentContext();
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 21;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2;
        switch (string) {
            case "multiline": {
                n2 = 1;
                break;
            }
            case "$*": {
                n2 = 2;
                break;
            }
            case "input": {
                n2 = 3;
                break;
            }
            case "$_": {
                n2 = 4;
                break;
            }
            case "lastMatch": {
                n2 = 5;
                break;
            }
            case "$&": {
                n2 = 6;
                break;
            }
            case "lastParen": {
                n2 = 7;
                break;
            }
            case "$+": {
                n2 = 8;
                break;
            }
            case "leftContext": {
                n2 = 9;
                break;
            }
            case "$`": {
                n2 = 10;
                break;
            }
            case "rightContext": {
                n2 = 11;
                break;
            }
            case "$'": {
                n2 = 12;
                break;
            }
            case "$1": {
                n2 = 13;
                break;
            }
            case "$2": {
                n2 = 14;
                break;
            }
            case "$3": {
                n2 = 15;
                break;
            }
            case "$4": {
                n2 = 16;
                break;
            }
            case "$5": {
                n2 = 17;
                break;
            }
            case "$6": {
                n2 = 18;
                break;
            }
            case "$7": {
                n2 = 19;
                break;
            }
            case "$8": {
                n2 = 20;
                break;
            }
            case "$9": {
                n2 = 21;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: {
                n = this.multilineAttr;
                break;
            }
            case 2: {
                n = this.starAttr;
                break;
            }
            case 3: {
                n = this.inputAttr;
                break;
            }
            case 4: {
                n = this.underscoreAttr;
                break;
            }
            default: {
                n = 5;
            }
        }
        return NativeRegExpCtor.instanceIdInfo(n, super.getMaxInstanceId() + n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (1 <= n2 && n2 <= 21) {
            switch (n2) {
                case 1: {
                    return "multiline";
                }
                case 2: {
                    return "$*";
                }
                case 3: {
                    return "input";
                }
                case 4: {
                    return "$_";
                }
                case 5: {
                    return "lastMatch";
                }
                case 6: {
                    return "$&";
                }
                case 7: {
                    return "lastParen";
                }
                case 8: {
                    return "$+";
                }
                case 9: {
                    return "leftContext";
                }
                case 10: {
                    return "$`";
                }
                case 11: {
                    return "rightContext";
                }
                case 12: {
                    return "$'";
                }
            }
            int n3 = n2 - 12 - 1;
            char[] cArray = new char[]{'$', (char)(49 + n3)};
            return new String(cArray);
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (1 <= n2 && n2 <= 21) {
            Object object;
            RegExpImpl regExpImpl = NativeRegExpCtor.getImpl();
            switch (n2) {
                case 1: 
                case 2: {
                    return ScriptRuntime.wrapBoolean(regExpImpl.multiline);
                }
                case 3: 
                case 4: {
                    object = regExpImpl.input;
                    break;
                }
                case 5: 
                case 6: {
                    object = regExpImpl.lastMatch;
                    break;
                }
                case 7: 
                case 8: {
                    object = regExpImpl.lastParen;
                    break;
                }
                case 9: 
                case 10: {
                    object = regExpImpl.leftContext;
                    break;
                }
                case 11: 
                case 12: {
                    object = regExpImpl.rightContext;
                    break;
                }
                default: {
                    int n3 = n2 - 12 - 1;
                    object = regExpImpl.getParenSubString(n3);
                    break;
                }
            }
            return object == null ? "" : object.toString();
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        int n2 = n - super.getMaxInstanceId();
        switch (n2) {
            case 1: 
            case 2: {
                NativeRegExpCtor.getImpl().multiline = ScriptRuntime.toBoolean(object);
                return;
            }
            case 3: 
            case 4: {
                NativeRegExpCtor.getImpl().input = ScriptRuntime.toString(object);
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        int n3 = n2 - 12 - 1;
        if (0 <= n3 && n3 <= 8) {
            return;
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        int n3 = n - super.getMaxInstanceId();
        switch (n3) {
            case 1: {
                this.multilineAttr = n2;
                return;
            }
            case 2: {
                this.starAttr = n2;
                return;
            }
            case 3: {
                this.inputAttr = n2;
                return;
            }
            case 4: {
                this.underscoreAttr = n2;
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        int n4 = n3 - 12 - 1;
        if (0 <= n4 && n4 <= 8) {
            return;
        }
        super.setInstanceIdAttributes(n, n2);
    }
}

