/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.DocumentBridge;
import io.sf.carte.echosvg.bridge.GenericBridge;
import io.sf.carte.echosvg.bridge.GraphicsNodeBridge;
import io.sf.carte.echosvg.bridge.InterruptedBridgeException;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.RootGraphicsNode;
import io.sf.carte.echosvg.util.HaltingThread;
import io.sf.carte.echosvg.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GVTBuilder
implements SVGConstants {
    public GraphicsNode build(BridgeContext bridgeContext, Document document) {
        bridgeContext.setDocument(document);
        bridgeContext.initializeDocument(document);
        bridgeContext.setGVTBuilder(this);
        DocumentBridge documentBridge = bridgeContext.getDocumentBridge();
        RootGraphicsNode rootGraphicsNode = null;
        try {
            rootGraphicsNode = documentBridge.createGraphicsNode(bridgeContext, document);
            Element element = document.getDocumentElement();
            GraphicsNode graphicsNode = null;
            Bridge bridge = bridgeContext.getBridge(element);
            if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
                return null;
            }
            GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
            graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
            if (graphicsNode == null) {
                return null;
            }
            rootGraphicsNode.getChildren().add(graphicsNode);
            this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
            graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
            documentBridge.buildGraphicsNode(bridgeContext, document, rootGraphicsNode);
        }
        catch (BridgeException bridgeException) {
            bridgeException.setGraphicsNode((GraphicsNode)rootGraphicsNode);
            throw bridgeException;
        }
        if (bridgeContext.isInteractive()) {
            bridgeContext.addUIEventListeners(document);
            bridgeContext.addGVTListener(document);
        }
        if (bridgeContext.isDynamic()) {
            bridgeContext.addDOMListeners();
        }
        return rootGraphicsNode;
    }

    public GraphicsNode build(BridgeContext bridgeContext, Element element) {
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(bridgeContext, element);
            this.handleGenericBridges(bridgeContext, element);
            return null;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            this.handleGenericBridges(bridgeContext, element);
            return null;
        }
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
        if (!graphicsNodeBridge.getDisplay(element)) {
            this.handleGenericBridges(bridgeContext, element);
            return null;
        }
        GraphicsNode graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
        if (graphicsNode != null) {
            if (graphicsNodeBridge.isComposite()) {
                this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
            } else {
                this.handleGenericBridges(bridgeContext, element);
            }
            graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
        }
        if (bridgeContext.isDynamic()) {
            // empty if block
        }
        return graphicsNode;
    }

    protected void buildComposite(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.buildGraphicsNode(bridgeContext, (Element)node, compositeGraphicsNode);
        }
    }

    protected void buildGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        if (HaltingThread.hasBeenHalted()) {
            throw new InterruptedBridgeException();
        }
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(bridgeContext, element);
            this.handleGenericBridges(bridgeContext, element);
            return;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            this.handleGenericBridges(bridgeContext, element);
            return;
        }
        if (!CSSUtilities.convertDisplay(element)) {
            this.handleGenericBridges(bridgeContext, element);
            return;
        }
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
        try {
            GraphicsNode graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
            if (graphicsNode != null) {
                compositeGraphicsNode.getChildren().add(graphicsNode);
                if (graphicsNodeBridge.isComposite()) {
                    this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
                } else {
                    this.handleGenericBridges(bridgeContext, element);
                }
                graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
            } else {
                this.handleGenericBridges(bridgeContext, element);
            }
        }
        catch (BridgeException bridgeException) {
            GraphicsNode graphicsNode = bridgeException.getGraphicsNode();
            if (graphicsNode != null) {
                compositeGraphicsNode.getChildren().add(graphicsNode);
                graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
                bridgeException.setGraphicsNode(null);
            }
            throw bridgeException;
        }
    }

    protected void handleGenericBridges(BridgeContext bridgeContext, Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            Bridge bridge = bridgeContext.getBridge(element2);
            if (bridge instanceof GenericBridge) {
                ((GenericBridge)bridge).handleElement(bridgeContext, element2);
            }
            this.handleGenericBridges(bridgeContext, element2);
        }
    }
}

