/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.merge.ui;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gephi.datalab.api.AttributeColumnsMergeStrategiesController;
import org.gephi.datalab.plugin.manipulators.columns.merge.BooleanLogicOperations;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.gephi.ui.utils.ColumnTitleValidator;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.util.NbBundle;

public class BooleanLogicOperationsUI
extends JPanel
implements ManipulatorUI {
    private BooleanLogicOperations manipulator;
    private JComboBox[] operationSelectors;
    private Table table;
    private DialogControls dialogControls;
    private JLabel descriptionLabel;
    private JPanel panel;
    private JScrollPane scroll;
    private JLabel titleLabel;
    private JTextField titleTextField;

    public BooleanLogicOperationsUI() {
        this.initComponents();
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.refreshOkButton();
            }

            private void refreshOkButton() {
                String text = BooleanLogicOperationsUI.this.titleTextField.getText();
                BooleanLogicOperationsUI.this.dialogControls.setOkButtonEnabled(text != null && !text.isEmpty() && !BooleanLogicOperationsUI.this.table.hasColumn(text));
            }
        });
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (BooleanLogicOperations)m;
        this.dialogControls = dialogControls;
        this.table = this.manipulator.getTable();
        this.prepareColumnsAndOperations();
    }

    public void unSetup() {
        AttributeColumnsMergeStrategiesController.BooleanOperations[] booleanOperations = new AttributeColumnsMergeStrategiesController.BooleanOperations[this.operationSelectors.length];
        for (int i = 0; i < booleanOperations.length; ++i) {
            booleanOperations[i] = (AttributeColumnsMergeStrategiesController.BooleanOperations)this.operationSelectors[i].getSelectedItem();
        }
        this.manipulator.setBooleanOperations(booleanOperations);
        this.manipulator.setNewColumnTitle(this.titleTextField.getText());
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = validationPanel.getValidationGroup();
        group.add((Object)this.titleTextField, (Validator)new ColumnTitleValidator(this.table));
        return validationPanel;
    }

    public boolean isModal() {
        return true;
    }

    private void prepareColumnsAndOperations() {
        Column[] columns = this.manipulator.getColumns();
        this.operationSelectors = new JComboBox[columns.length - 1];
        for (int i = 0; i < columns.length; ++i) {
            JLabel columnLabel = new JLabel(columns[i].getTitle());
            columnLabel.setHorizontalAlignment(0);
            this.panel.add(columnLabel);
            if (i >= columns.length - 1) continue;
            this.operationSelectors[i] = this.prepareOperationSelector();
            this.panel.add(this.operationSelectors[i]);
        }
    }

    private JComboBox prepareOperationSelector() {
        JComboBox<AttributeColumnsMergeStrategiesController.BooleanOperations> selector = new JComboBox<AttributeColumnsMergeStrategiesController.BooleanOperations>(AttributeColumnsMergeStrategiesController.BooleanOperations.values());
        return selector;
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.scroll = new JScrollPane();
        this.panel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.descriptionLabel.setText(NbBundle.getMessage(BooleanLogicOperationsUI.class, (String)"BooleanLogicOperationsUI.descriptionLabel.text"));
        this.panel.setLayout(new GridLayout(0, 1, 0, 20));
        this.scroll.setViewportView(this.panel);
        this.titleLabel.setText(NbBundle.getMessage(BooleanLogicOperationsUI.class, (String)"BooleanLogicOperationsUI.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(BooleanLogicOperationsUI.class, (String)"BooleanLogicOperationsUI.titleTextField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, 254, Short.MAX_VALUE).addComponent(this.scroll, -1, 254, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleTextField, -1, 135, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionLabel, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 105, Short.MAX_VALUE).addContainerGap()));
    }
}

