/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.types;

import java.awt.Color;

public final class DependantColor {
    private final Color customColor;
    private final Mode mode;

    public DependantColor() {
        this.customColor = null;
        this.mode = Mode.PARENT;
    }

    public DependantColor(Mode mode) {
        this.customColor = mode.equals((Object)Mode.CUSTOM) ? Color.BLACK : null;
        this.mode = mode;
    }

    public DependantColor(Color customColor) {
        this.customColor = customColor;
        this.mode = Mode.CUSTOM;
    }

    public Color getCustomColor() {
        return this.customColor;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Color getColor(Color parentColor) {
        if (this.mode.equals((Object)Mode.CUSTOM) && this.customColor != null) {
            return this.customColor;
        }
        if (this.mode.equals((Object)Mode.DARKER)) {
            return parentColor.darker();
        }
        return parentColor;
    }

    public static enum Mode {
        PARENT,
        CUSTOM,
        DARKER;

    }
}

