#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-A4C3Z30WXty51d2tshYgjq
key:                  hOpenPGP-2.10.1-A4C3Z30WXty51d2tshYgjq
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  76baf43794477107eb745b45b81b676f
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-A4C3Z30WXty51d2tshYgjq
depends:
    aeson-2.1.2.1-nTcMAwSjFOFbKrX5mWkol
    asn1-encoding-0.9.6-73LtH9mPN2tEtFnZCEo0ah
    attoparsec-0.14.4-LmTKTFLXrumHz4pqfqNh8g base-4.17.2.1
    base16-bytestring-1.0.2.0-4VKZSMAQma4FWplzwntFGI
    bifunctors-5.6.2-IxntaptJGqQ3qHgeyi9LXe binary-0.8.9.1
    binary-conduit-1.3.1-M09aUTlYYmIfPhLMbe5n7 bytestring-0.11.5.3
    bz2-1.0.1.1-HSesA5LIkRgKToargRrvEX
    conduit-1.3.6.1-GPe8u3RYhCEKxuB1doj8qM
    conduit-extra-1.3.8-H0Ux7lWGa6s1NvcyXyCw5o containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-GiPin2eey3PDLdMPJWrRi1
    errors-2.3.0-29tNsoWqUcV1rC3vZtyFnr
    hashable-1.4.6.0-AnOmtRToJbI9DS9f6Gdy0i
    incremental-parser-0.5.1-9LcoCr7RKgLAwJ8W1K28Sh
    ixset-typed-0.5.1.0-HjX7KHVr99E2jYGQkw6dBh
    lens-5.3.2-fiszOW9VlT8rCDJtY0rRn
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-IgEz3CB1YIOEy0roDjtsJm
    openpgp-asciiarmor-0.1.2-DvPqITXzUPlCzDWnSCtD4z
    prettyprinter-1.7.1-AF4Gt6IhKUy3k7s13EBNuD
    resourcet-1.2.6-8zJ4onmdcE7Bb7T1oAZJH7
    split-0.2.5-Jw4n4gsdaZK4FHILOCxPWx text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-KDi8IgRcOV5HCm7hBAqDWV
    zlib-0.7.0.0-HZpZHQDuBUK2q5bSmtjxXS

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

