#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.42
visibility:           public
id:                   hledger-1.42-1Bf44kTm2sCCLkqTpC2v3M
key:                  hledger-1.42-1Bf44kTm2sCCLkqTpC2v3M
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  b8d9f6e042b07692327aedafa2c7001c
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Stats Hledger.Cli.Commands.Tags
    Hledger.Cli.CompoundBalanceCommand Hledger.Cli.Conf
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.42
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.42
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.42
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.42-1Bf44kTm2sCCLkqTpC2v3M
depends:
    Decimal-0.5.2-DeXkGpxcOYSFP5ByuNCgAq Diff-0.5-HAcFInTibw312RXP7RmH2
    aeson-2.1.2.1-25X5lEqka86CxkXK2BMN9E
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-DedLaMdyNo8JhhbUq8RBU3
    filepath-1.4.2.2 githash-0.1.6.3-5nQf0PyKAyv5qIlWDyr7Nf
    hashable-1.4.6.0-HsdqsQ7iDyd40AcboGWr8K haskeline-0.8.2
    hledger-lib-1.42-6D2W1Q6Gwxh2rJ1bT0w89s
    lucid-2.11.20250303-KUyupOQCLvq6RdHp76yFuk
    math-functions-0.3.4.4-6xCp4TebtLZ8qqR5MVivZG
    megaparsec-9.7.0-JOqeKsXL95c1CDbf8BIVid
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-A6IVJ310RJQ4UQcu7RgMnP mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-Ehlt0m2SBCjGyOeVQxYb9I
    safe-0.3.21-IyrA7K5ohwh1bwsZPWGLKL
    shakespeare-2.1.4-7sl7NNTl6kp9BbiHD6pu7D
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-Jv6LOcKt1D0FKIqQvCcHaE
    temporary-1.3-5ZcHA3uqaJ21DveNvUEfLl text-2.0.2
    text-ansi-0.3.0.1-4W4iTUMpFgcH6YjxzswY5U time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-DjNgsRwGYvfHy5WsKzKUzR
    utf8-string-1.0.2-9Em8uVxkJRhLhA62Ke5gub
    utility-ht-0.0.17.2-8DNJvJgLPBHHWwDmXZmmHV
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

