/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter computes the distance map of the input image as an
approximation with pixel accuracy to the Euclidean distance.


TInputImage

Input Image Type

TOutputImage

Output Image Type

TVoronoiImage

Voronoi Image Type. Note the default value is TInputImage.

The input is assumed to contain numeric codes defining objects. The
filter will produce as output the following images:


A Voronoi partition using the same numeric codes as the input.

A distance map with the approximation to the euclidean distance. from
a particular pixel to the nearest object to this pixel in the input
image.

A vector map containing the component of the vector relating the
current pixel with the closest point of the closest object to this
pixel. Given that the components of the distance are computed in
"pixels", the vector is represented by an itk::Offset . That is, physical coordinates are not used.
 This filter is N-dimensional and known to be efficient in
computational time. The algorithm is the N-dimensional version of the
4SED algorithm given for two dimensions in:

Danielsson, Per-Erik. Euclidean Distance Mapping. Computer Graphics
and Image Processing 14, 227-248 (1980).
See:
 itk::simple::DanielssonDistanceMap for the procedural interface

 itk::DanielssonDistanceMapImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDanielssonDistanceMapImageFilter.h
*/
public class DanielssonDistanceMapImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DanielssonDistanceMapImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DanielssonDistanceMapImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DanielssonDistanceMapImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DanielssonDistanceMapImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DanielssonDistanceMapImageFilter::~DanielssonDistanceMapImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DanielssonDistanceMapImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DanielssonDistanceMapImageFilter::DanielssonDistanceMapImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DanielssonDistanceMapImageFilter() {
    this(SimpleITKJNI.new_DanielssonDistanceMapImageFilter(), true);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::SetInputIsBinary(bool InputIsBinary)

Set/Get if the input is binary. If this variable is set, each nonzero
pixel in the input image will be given a unique numeric code to be
used by the Voronoi partition. If the image is binary but you are not
interested in the Voronoi regions of the different nonzero pixels,
then you need not set this.

*/
public  void setInputIsBinary(boolean InputIsBinary) {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_setInputIsBinary(swigCPtr, this, InputIsBinary);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::InputIsBinaryOn()

Set the value of InputIsBinary to true or false respectfully.

*/
public  void inputIsBinaryOn() {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_inputIsBinaryOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::InputIsBinaryOff()
*/
public  void inputIsBinaryOff() {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_inputIsBinaryOff(swigCPtr, this);
  }

  /**
bool itk::simple::DanielssonDistanceMapImageFilter::GetInputIsBinary() const

Set/Get if the input is binary. If this variable is set, each nonzero
pixel in the input image will be given a unique numeric code to be
used by the Voronoi partition. If the image is binary but you are not
interested in the Voronoi regions of the different nonzero pixels,
then you need not set this.

*/
public  boolean getInputIsBinary() {
    return SimpleITKJNI.DanielssonDistanceMapImageFilter_getInputIsBinary(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::SetSquaredDistance(bool SquaredDistance)

Set/Get if the distance should be squared.

*/
public  void setSquaredDistance(boolean SquaredDistance) {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_setSquaredDistance(swigCPtr, this, SquaredDistance);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::SquaredDistanceOn()

Set the value of SquaredDistance to true or false respectfully.

*/
public  void squaredDistanceOn() {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_squaredDistanceOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::SquaredDistanceOff()
*/
public  void squaredDistanceOff() {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_squaredDistanceOff(swigCPtr, this);
  }

  /**
bool itk::simple::DanielssonDistanceMapImageFilter::GetSquaredDistance() const

Set/Get if the distance should be squared.

*/
public  boolean getSquaredDistance() {
    return SimpleITKJNI.DanielssonDistanceMapImageFilter_getSquaredDistance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get if image spacing should be used in computing distances.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DanielssonDistanceMapImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.DanielssonDistanceMapImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::DanielssonDistanceMapImageFilter::GetUseImageSpacing() const

Set/Get if image spacing should be used in computing distances.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.DanielssonDistanceMapImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
Image itk::simple::DanielssonDistanceMapImageFilter::GetVoronoiMap() const

Get Voronoi Map This map shows for each pixel what object is closest
to it. Each object should be labeled by a number (larger than 0), so
the map has a value for each pixel corresponding to the label of the
closest object.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  Image getVoronoiMap() {
    return new Image(SimpleITKJNI.DanielssonDistanceMapImageFilter_getVoronoiMap(swigCPtr, this), true);
  }

  /**
Image itk::simple::DanielssonDistanceMapImageFilter::GetVectorDistanceMap() const

Get vector field of distances.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  Image getVectorDistanceMap() {
    return new Image(SimpleITKJNI.DanielssonDistanceMapImageFilter_getVectorDistanceMap(swigCPtr, this), true);
  }

  /**
std::string itk::simple::DanielssonDistanceMapImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DanielssonDistanceMapImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DanielssonDistanceMapImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DanielssonDistanceMapImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DanielssonDistanceMapImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.DanielssonDistanceMapImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
