/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

The direct linear inverse deconvolution filter.


The inverse filter is the most straightforward deconvolution method.
Considering that convolution of two images in the spatial domain is
equivalent to multiplying the Fourier transform of the two images, the
inverse filter consists of inverting the multiplication. In other
words, this filter computes the following: \\[ hat{F}(\\omega) = \\begin{cases} G(\\omega) / H(\\omega)
&amp; \\text{if \\f$|H(\\omega)| \\geq \\epsilon\\f$}
\\\\ 0 &amp; \\text{otherwise} \\end{cases} \\] where $\\hat{F}(\\omega)$ is the Fourier transform of the estimate produced by this filter, $G(\\omega)$ is the Fourier transform of the input blurred image, $H(\\omega)$ is the Fourier transform of the blurring kernel, and $\\epsilon$ is a constant real non-negative threshold (called
KernelZeroMagnitudeThreshold in this filter) that determines when the
magnitude of a complex number is considered zero.


Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France

Cory Quammen, The University of North Carolina at Chapel Hill

See:
 itk::simple::InverseDeconvolution for the procedural interface

 itk::InverseDeconvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkInverseDeconvolutionImageFilter.h
*/
public class InverseDeconvolutionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected InverseDeconvolutionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.InverseDeconvolutionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(InverseDeconvolutionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(InverseDeconvolutionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::InverseDeconvolutionImageFilter::~InverseDeconvolutionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_InverseDeconvolutionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::InverseDeconvolutionImageFilter::InverseDeconvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  InverseDeconvolutionImageFilter() {
    this(SimpleITKJNI.new_InverseDeconvolutionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::InverseDeconvolutionImageFilter::SetKernelZeroMagnitudeThreshold(double KernelZeroMagnitudeThreshold)

Set/get the threshold value used to determine whether a frequency of
the Fourier transform of the blurring kernel is considered to be zero.
Default value is 1.0e-4.

*/
public  void setKernelZeroMagnitudeThreshold(double KernelZeroMagnitudeThreshold) {
    SimpleITKJNI.InverseDeconvolutionImageFilter_setKernelZeroMagnitudeThreshold(swigCPtr, this, KernelZeroMagnitudeThreshold);
  }

  /**
double itk::simple::InverseDeconvolutionImageFilter::GetKernelZeroMagnitudeThreshold() const

Set/get the threshold value used to determine whether a frequency of
the Fourier transform of the blurring kernel is considered to be zero.
Default value is 1.0e-4.

*/
public  double getKernelZeroMagnitudeThreshold() {
    return SimpleITKJNI.InverseDeconvolutionImageFilter_getKernelZeroMagnitudeThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::InverseDeconvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public  void setNormalize(boolean Normalize) {
    SimpleITKJNI.InverseDeconvolutionImageFilter_setNormalize(swigCPtr, this, Normalize);
  }

  /**
Self&amp; itk::simple::InverseDeconvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public  void normalizeOn() {
    SimpleITKJNI.InverseDeconvolutionImageFilter_normalizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::InverseDeconvolutionImageFilter::NormalizeOff()
*/
public  void normalizeOff() {
    SimpleITKJNI.InverseDeconvolutionImageFilter_normalizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::InverseDeconvolutionImageFilter::GetNormalize() const
*/
public  boolean getNormalize() {
    return SimpleITKJNI.InverseDeconvolutionImageFilter_getNormalize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::InverseDeconvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(InverseDeconvolutionImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.InverseDeconvolutionImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::InverseDeconvolutionImageFilter::GetBoundaryCondition() const
*/
public  InverseDeconvolutionImageFilter.BoundaryConditionType getBoundaryCondition() {
    return InverseDeconvolutionImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.InverseDeconvolutionImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::InverseDeconvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public  void setOutputRegionMode(InverseDeconvolutionImageFilter.OutputRegionModeType OutputRegionMode) {
    SimpleITKJNI.InverseDeconvolutionImageFilter_setOutputRegionMode(swigCPtr, this, OutputRegionMode.swigValue());
  }

  /**
OutputRegionModeType itk::simple::InverseDeconvolutionImageFilter::GetOutputRegionMode() const
*/
public  InverseDeconvolutionImageFilter.OutputRegionModeType getOutputRegionMode() {
    return InverseDeconvolutionImageFilter.OutputRegionModeType.swigToEnum(SimpleITKJNI.InverseDeconvolutionImageFilter_getOutputRegionMode(swigCPtr, this));
  }

  /**
std::string itk::simple::InverseDeconvolutionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.InverseDeconvolutionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::InverseDeconvolutionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.InverseDeconvolutionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::InverseDeconvolutionImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.InverseDeconvolutionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public final static class BoundaryConditionType {
    public final static InverseDeconvolutionImageFilter.BoundaryConditionType ZERO_PAD = new InverseDeconvolutionImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static InverseDeconvolutionImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new InverseDeconvolutionImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static InverseDeconvolutionImageFilter.BoundaryConditionType PERIODIC_PAD = new InverseDeconvolutionImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class OutputRegionModeType {
    public final static InverseDeconvolutionImageFilter.OutputRegionModeType SAME = new InverseDeconvolutionImageFilter.OutputRegionModeType("SAME");
    public final static InverseDeconvolutionImageFilter.OutputRegionModeType VALID = new InverseDeconvolutionImageFilter.OutputRegionModeType("VALID");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OutputRegionModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OutputRegionModeType.class + " with value " + swigValue);
    }

    private OutputRegionModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OutputRegionModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OutputRegionModeType(String swigName, OutputRegionModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OutputRegionModeType[] swigValues = { SAME, VALID };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
