/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the XOR bitwise operator pixel-wise between two images.


This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

Since the bitwise XOR operation is only defined in C++ for integer
types, the images passed to this filter must comply with the
requirement of using integer pixel type.

The total operation over one pixel will be


Where "^" is the boolean XOR operator in C++.
See:
 itk::simple::Xor for the procedural interface

 itk::XorImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkXorImageFilter.h
*/
public class XorImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected XorImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.XorImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(XorImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(XorImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::XorImageFilter::~XorImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_XorImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::XorImageFilter::XorImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  XorImageFilter() {
    this(SimpleITKJNI.new_XorImageFilter(), true);
  }

  /**
std::string itk::simple::XorImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.XorImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::XorImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.XorImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::XorImageFilter::Execute(int constant, const Image &amp;image2)
*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.XorImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::XorImageFilter::Execute(int constant, const Image &amp;image2)
*/
public  Image execute(Image image1, int constant) {
    return new Image(SimpleITKJNI.XorImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::XorImageFilter::Execute(int constant, const Image &amp;image2)
*/
public  Image execute(int constant, Image image2) {
    return new Image(SimpleITKJNI.XorImageFilter_execute__SWIG_2(swigCPtr, this, constant, Image.getCPtr(image2), image2), true);
  }

}
