/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.tools.CheckParameterUtil;

@FunctionalInterface
public interface IDataSelectionListener<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>, D extends OsmData<O, N, W, R>> {
    public void selectionChanged(SelectionChangeEvent<O, N, W, R, D> var1);

    public static class SelectionToggleEvent<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>, D extends OsmData<O, N, W, R>>
    extends AbstractSelectionEvent<O, N, W, R, D> {
        private final Set<O> current;
        private final Set<O> remove;
        private final Set<O> add;

        public SelectionToggleEvent(D source, Set<O> old, Stream<O> toToggle) {
            super(source, old);
            LinkedHashSet currentSet = new LinkedHashSet(old);
            LinkedHashSet removeSet = new LinkedHashSet();
            LinkedHashSet addSet = new LinkedHashSet();
            toToggle.forEach(p -> {
                if (currentSet.remove(p)) {
                    removeSet.add(p);
                } else {
                    addSet.add(p);
                    currentSet.add(p);
                }
            });
            this.current = Collections.unmodifiableSet(currentSet);
            this.remove = Collections.unmodifiableSet(removeSet);
            this.add = Collections.unmodifiableSet(addSet);
        }

        @Override
        public Set<O> getSelection() {
            return this.current;
        }

        @Override
        public Set<O> getRemoved() {
            return this.remove;
        }

        @Override
        public Set<O> getAdded() {
            return this.add;
        }

        public String toString() {
            return "SelectionToggleEvent [current=" + this.current + ", remove=" + this.remove + ", add=" + this.add + "]";
        }
    }

    public static class SelectionRemoveEvent<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>, D extends OsmData<O, N, W, R>>
    extends AbstractSelectionEvent<O, N, W, R, D> {
        private final Set<O> remove;
        private final Set<O> current;

        public SelectionRemoveEvent(D source, Set<O> old, Stream<O> toRemove) {
            super(source, old);
            this.remove = toRemove.filter(old::contains).collect(Collectors.toCollection(LinkedHashSet::new));
            if (this.remove.isEmpty()) {
                this.current = this.getOldSelection();
            } else {
                LinkedHashSet<O> currentSet = new LinkedHashSet<O>(old);
                currentSet.removeAll(this.remove);
                this.current = currentSet;
            }
        }

        @Override
        public Set<O> getSelection() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<O> getRemoved() {
            return Collections.unmodifiableSet(this.remove);
        }

        @Override
        public Set<O> getAdded() {
            return Collections.emptySet();
        }

        public String toString() {
            return "SelectionRemoveEvent [remove=" + this.remove + ", current=" + this.current + "]";
        }
    }

    public static class SelectionAddEvent<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>, D extends OsmData<O, N, W, R>>
    extends AbstractSelectionEvent<O, N, W, R, D> {
        private final Set<O> add;
        private final Set<O> current;

        public SelectionAddEvent(D source, Set<O> old, Stream<O> toAdd) {
            super(source, old);
            this.add = toAdd.filter(p -> !old.contains(p)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (this.add.isEmpty()) {
                this.current = this.getOldSelection();
            } else {
                this.current = new LinkedHashSet<O>(old);
                this.current.addAll(this.add);
            }
        }

        @Override
        public Set<O> getSelection() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<O> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public Set<O> getAdded() {
            return Collections.unmodifiableSet(this.add);
        }

        public String toString() {
            return "SelectionAddEvent [add=" + this.add + ", current=" + this.current + "]";
        }
    }

    public static class SelectionReplaceEvent<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>, D extends OsmData<O, N, W, R>>
    extends AbstractSelectionEvent<O, N, W, R, D> {
        private final Set<O> current;
        private Set<O> removed;
        private Set<O> added;

        public SelectionReplaceEvent(D source, Set<O> old, Stream<O> newSelection) {
            super(source, old);
            this.current = newSelection.collect(Collectors.toCollection(LinkedHashSet::new));
        }

        @Override
        public Set<O> getSelection() {
            return this.current;
        }

        @Override
        public synchronized Set<O> getRemoved() {
            if (this.removed == null) {
                this.removed = this.getOldSelection().stream().filter(p -> !this.current.contains(p)).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            return this.removed;
        }

        @Override
        public synchronized Set<O> getAdded() {
            if (this.added == null) {
                this.added = this.current.stream().filter(p -> !this.getOldSelection().contains(p)).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            return this.added;
        }

        public String toString() {
            return "SelectionReplaceEvent [current=" + this.current + ", removed=" + this.removed + ", added=" + this.added + "]";
        }
    }

    public static abstract class AbstractSelectionEvent<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>, D extends OsmData<O, N, W, R>>
    implements SelectionChangeEvent<O, N, W, R, D> {
        private final D source;
        private final Set<O> old;

        protected AbstractSelectionEvent(D source, Set<O> old) {
            CheckParameterUtil.ensureParameterNotNull(source, "source");
            CheckParameterUtil.ensureParameterNotNull(old, "old");
            this.source = source;
            this.old = Collections.unmodifiableSet(old);
        }

        @Override
        public Set<O> getOldSelection() {
            return this.old;
        }

        @Override
        public D getSource() {
            return this.source;
        }
    }

    public static interface SelectionChangeEvent<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>, D extends OsmData<O, N, W, R>> {
        public Set<O> getOldSelection();

        public Set<O> getSelection();

        public Set<O> getRemoved();

        public Set<O> getAdded();

        public D getSource();

        default public boolean isNop() {
            return this.getAdded().isEmpty() && this.getRemoved().isEmpty();
        }
    }
}

