/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.vector;

import java.util.List;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.UniqueIdGenerator;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.vector.VectorPrimitive;
import org.openstreetmap.josm.tools.Utils;

public class VectorNode
extends VectorPrimitive
implements INode {
    private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator();
    private double lon = Double.NaN;
    private double lat = Double.NaN;

    public VectorNode(String layer) {
        super(layer);
    }

    @Override
    public double lon() {
        return this.lon;
    }

    @Override
    public double lat() {
        return this.lat;
    }

    @Override
    public UniqueIdGenerator getIdGenerator() {
        return ID_GENERATOR;
    }

    @Override
    public LatLon getCoor() {
        return new LatLon(this.lat, this.lon);
    }

    @Override
    public void setCoor(LatLon coordinates) {
        this.lat = coordinates.lat();
        this.lon = coordinates.lon();
    }

    public void setCoor(ICoordinate coordinates) {
        this.lat = coordinates.getLat();
        this.lon = coordinates.getLon();
    }

    @Override
    public void setEastNorth(EastNorth eastNorth) {
        LatLon ll = ProjectionRegistry.getProjection().eastNorth2latlon(eastNorth);
        this.lat = ll.lat();
        this.lon = ll.lon();
    }

    @Override
    public boolean isReferredByWays(int n) {
        List<? extends IPrimitive> referrers = super.getReferrers();
        if (Utils.isEmpty(referrers)) {
            return false;
        }
        if (referrers instanceof IPrimitive) {
            return n <= 1 && referrers instanceof IWay && ((IPrimitive)((Object)referrers)).getDataSet() == this.getDataSet();
        }
        int counter = 0;
        for (IPrimitive iPrimitive : referrers) {
            if (this.getDataSet() != iPrimitive.getDataSet() || !(iPrimitive instanceof IWay) || ++counter < n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BBox getBBox() {
        return new BBox(this.lon, this.lat).toImmutable();
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }
}

