/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.logstream;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.StreamingLogHandlerBuildItem;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.logging.LoggingDecorateBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.runtime.logstream.LogStreamBroadcaster;
import io.quarkus.devui.runtime.logstream.LogStreamJsonRPCService;
import io.quarkus.devui.runtime.logstream.LogStreamRecorder;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.logging.LogBuildTimeConfig;
import java.util.Map;
import java.util.Optional;

public class LogStreamProcessor {
    private final String namespace = "devui-logstream";

    @BuildStep(onlyIf={IsDevelopment.class})
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(LogStreamBroadcaster.class).setUnremovable().build());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void handler(BuildProducer<StreamingLogHandlerBuildItem> streamingLogHandlerBuildItem, LogBuildTimeConfig logBuildTimeConfig, LoggingDecorateBuildItem loggingDecorateBuildItem, LogStreamRecorder recorder) {
        RuntimeValue mutinyLogHandler = recorder.mutinyLogHandler(logBuildTimeConfig.decorateStacktraces(), loggingDecorateBuildItem.getSrcMainJava().toString(), loggingDecorateBuildItem.getKnowClasses());
        streamingLogHandlerBuildItem.produce((BuildItem)new StreamingLogHandlerBuildItem(mutinyLogHandler));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void createJsonRPCService(BuildProducer<JsonRPCProvidersBuildItem> jsonRPCProvidersProducer, BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, LaunchModeBuildItem launchModeBuildItem) {
        Optional ts = TestSupport.instance();
        BuildTimeActionBuildItem keyStrokeActions = new BuildTimeActionBuildItem("devui-logstream");
        keyStrokeActions.addAction("forceRestart", ignored -> {
            RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
            return Map.of();
        });
        keyStrokeActions.addAction("rerunAllTests", ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            if (((TestSupport)ts.get()).isStarted()) {
                ((TestSupport)ts.get()).runAllTests();
                return Map.of();
            }
            ((TestSupport)ts.get()).start();
            return Map.of("running", ((TestSupport)ts.get()).isRunning());
        });
        keyStrokeActions.addAction("rerunFailedTests", ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            ((TestSupport)ts.get()).runFailedTests();
            return Map.of();
        });
        keyStrokeActions.addAction("toggleBrokenOnly", ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            boolean brokenOnlyMode = ((TestSupport)ts.get()).toggleBrokenOnlyMode();
            return Map.of("brokenOnlyMode", brokenOnlyMode);
        });
        keyStrokeActions.addAction("printFailures", ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            ((TestSupport)ts.get()).printFullResults();
            return Map.of();
        });
        keyStrokeActions.addAction("toggleTestOutput", ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            boolean isTestOutput = ((TestSupport)ts.get()).toggleTestOutput();
            return Map.of("isTestOutput", isTestOutput);
        });
        keyStrokeActions.addAction("toggleInstrumentationReload", ignored -> {
            boolean instrumentationEnabled = RuntimeUpdatesProcessor.INSTANCE.toggleInstrumentation();
            return Map.of("instrumentationEnabled", instrumentationEnabled);
        });
        keyStrokeActions.addAction("pauseTests", ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            if (((TestSupport)ts.get()).isStarted()) {
                ((TestSupport)ts.get()).stop();
                return Map.of("running", ((TestSupport)ts.get()).isRunning());
            }
            return Map.of();
        });
        keyStrokeActions.addAction("toggleLiveReload", ignored -> {
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return Map.of();
            }
            boolean liveReloadEnabled = ((TestSupport)ts.get()).toggleLiveReloadEnabled();
            return Map.of("liveReloadEnabled", liveReloadEnabled);
        });
        buildTimeActionProducer.produce((BuildItem)keyStrokeActions);
        jsonRPCProvidersProducer.produce((BuildItem)new JsonRPCProvidersBuildItem("devui-logstream", LogStreamJsonRPCService.class));
    }

    private boolean testsDisabled(LaunchModeBuildItem launchModeBuildItem, Optional<TestSupport> ts) {
        return ts.isEmpty() || launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL;
    }
}

