/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.console;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.ConsoleCommandBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.console.ConsoleCommand;
import io.quarkus.deployment.console.ConsoleStateManager;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.deployment.ide.IdeProcessor;
import io.quarkus.devui.runtime.config.ConfigDescription;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescriptionsManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommand;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.validator.CommandValidator;
import org.aesh.command.validator.CommandValidatorException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConsoleProcessor {
    static volatile ConsoleStateManager.ConsoleContext context;

    @Produce(value=ServiceStartBuildItem.class)
    @BuildStep
    void setupConsole(HttpRootPathBuildItem rp, NonApplicationRootPathBuildItem np, LaunchModeBuildItem launchModeBuildItem) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return;
        }
        if (context == null) {
            context = ConsoleStateManager.INSTANCE.createContext("HTTP");
        }
        Config c = ConfigProvider.getConfig();
        String host = c.getOptionalValue("quarkus.http.host", String.class).orElse("localhost");
        boolean isInsecureDisabled = c.getOptionalValue("quarkus.http.insecure-requests", String.class).map("disabled"::equals).orElse(false);
        String port = isInsecureDisabled ? c.getOptionalValue("quarkus.http.ssl-port", String.class).orElse("8443") : c.getOptionalValue("quarkus.http.port", String.class).orElse("8080");
        String protocol = isInsecureDisabled ? "https" : "http";
        context.reset(new ConsoleCommand[]{new ConsoleCommand('w', "Open the application in a browser", null, () -> IdeProcessor.openBrowser(rp, np, protocol, "/", host, port)), new ConsoleCommand('d', "Open the Dev UI in a browser", null, () -> IdeProcessor.openBrowser(rp, np, protocol, "/q/dev-ui", host, port))});
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void config(List<ConfigDescriptionBuildItem> configDescriptionBuildItems, BuildProducer<ConsoleCommandBuildItem> consoleCommandBuildItemBuildProducer, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>();
        for (ConfigDescriptionBuildItem item : configDescriptionBuildItems) {
            configDescriptions.add(new ConfigDescription(item.getPropertyName(), ConsoleProcessor.cleanUpAsciiDocIfNecessary(item.getDocs()), item.getDefaultValue(), ConsoleProcessor.isSetByDevServices(devServicesLauncherConfig, item.getPropertyName()), item.getValueTypeName(), item.getAllowedValues(), item.getConfigPhase().name()));
        }
        HashSet devServicesConfig = new HashSet();
        if (devServicesLauncherConfig.isPresent()) {
            devServicesConfig.addAll(devServicesLauncherConfig.get().getConfig().keySet());
        }
        consoleCommandBuildItemBuildProducer.produce((BuildItem)new ConsoleCommandBuildItem((Command)new ConfigCommandGroup(new ConfigDescriptionsManager(configDescriptions))));
    }

    public static boolean isSetByDevServices(Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, String propertyName) {
        if (devServicesLauncherConfig.isPresent()) {
            return devServicesLauncherConfig.get().getConfig().containsKey(propertyName);
        }
        return false;
    }

    public static String cleanUpAsciiDocIfNecessary(String docs) {
        if (docs == null || !docs.toLowerCase(Locale.ROOT).contains("@asciidoclet")) {
            return docs;
        }
        return docs.replace("@asciidoclet", "").replace("<<", "&lt;&lt;").replace(">>", "&gt;&gt;").replace("\n\n", "<p>").replace("\n", "<br>");
    }

    @GroupCommandDefinition(name="config", description="Config Editing Commands")
    public static class ConfigCommandGroup
    implements GroupCommand {
        final ConfigDescriptionsManager configDescriptionsManager;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        public boolean help;

        public ConfigCommandGroup(ConfigDescriptionsManager configDescriptionsManager) {
            this.configDescriptionsManager = configDescriptionsManager;
        }

        public List<Command> getCommands() {
            return List.of(new SetConfigCommand(this.configDescriptionsManager));
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.getShell().writeln(commandInvocation.getHelpInfo());
            return CommandResult.SUCCESS;
        }
    }

    public static class SetValidator
    implements CommandValidator<SetConfigCommand, CommandInvocation> {
        public void validate(SetConfigCommand command) throws CommandValidatorException {
            for (int i = 0; i < command.command.length() - 1; ++i) {
                if (command.command.charAt(i) != '=') continue;
                return;
            }
            throw new CommandValidatorException("Set command must be in the form key=value");
        }
    }

    public static class SetConfigCompleter
    implements OptionCompleter<CompleterInvocation> {
        public void complete(CompleterInvocation completerInvocation) {
            String soFar = completerInvocation.getGivenCompleteValue();
            String configKey = null;
            if (soFar.indexOf(61) != -1) {
                configKey = soFar.substring(0, soFar.indexOf(61));
            }
            SetConfigCommand command = (SetConfigCommand)completerInvocation.getCommand();
            HashSet<CallSite> possible = new HashSet<CallSite>();
            for (List j : command.configDescriptionsManager.values().values()) {
                for (ConfigDescription i : j) {
                    if (i.getDescription() == null) continue;
                    if (configKey != null && configKey.equals(i.getName())) {
                        if (i.getAllowedValues() != null && !i.getAllowedValues().isEmpty()) {
                            for (String val : i.getAllowedValues()) {
                                String value = i.getName() + "=" + val;
                                if (!value.startsWith(soFar)) continue;
                                completerInvocation.addCompleterValue(value);
                            }
                        }
                        return;
                    }
                    if (i.isWildcardEntry()) continue;
                    if (i.getName().equals(soFar)) {
                        possible.add((CallSite)((Object)(soFar + "=")));
                        continue;
                    }
                    if (!i.getName().startsWith(soFar)) continue;
                    int pos = i.getName().indexOf(46, soFar.length() + 1);
                    if (pos == -1) {
                        possible.add((CallSite)((Object)(i.getName() + "=")));
                        continue;
                    }
                    possible.add((CallSite)((Object)(i.getName().substring(0, pos) + ".")));
                }
            }
            completerInvocation.setAppendSpace(false);
            completerInvocation.addAllCompleterValues(possible);
        }
    }

    @CommandDefinition(name="set", description="Sets a config value", validator=SetValidator.class)
    public static class SetConfigCommand
    implements Command<CommandInvocation> {
        final ConfigDescriptionsManager configDescriptionsManager;
        @Argument(required=true, completer=SetConfigCompleter.class)
        private String command;

        public SetConfigCommand(ConfigDescriptionsManager configDescriptionsManager) {
            this.configDescriptionsManager = configDescriptionsManager;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            int pos = this.command.indexOf(61);
            String key = this.command.substring(0, pos);
            String value = this.command.substring(pos + 1);
            CurrentConfig.EDITOR.accept(Map.of(key, value));
            return CommandResult.SUCCESS;
        }
    }
}

