/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.util.LauncherLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Win32Handle {
    private static final String LIB_MODULES = "lib\\modules";
    private static final String LANMAN_REDIRECTOR_PREFIX = "\\Device\\LanmanRedirector\\;";
    private static final String MUP_DEVICE_PATH = "\\Device\\Mup";

    private static native Object[] list0();

    private static native boolean close0(int var0);

    private static native String getDeviceName0(String var0);

    public static boolean close(FileHandle fileHandle) {
        return Win32Handle.close0(fileHandle.handle);
    }

    public static List<FileHandle> list() {
        Object[] list = Win32Handle.list0();
        if (list == null) {
            return null;
        }
        int[] handles = (int[])list[0];
        String[] names = (String[])list[1];
        ArrayList<FileHandle> ret = new ArrayList<FileHandle>();
        for (int i = 0; i < names.length; ++i) {
            ret.add(new FileHandle(handles[i], names[i]));
        }
        return ret;
    }

    public static String getDevicePath(File file) {
        if (file != null) {
            return Win32Handle.getDevicePath(file.getAbsolutePath());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDevicePath(String fileName) {
        if (fileName == null || fileName.length() <= 2) return null;
        if (fileName.charAt(1) == ':') {
            String deviceName = Win32Handle.getDeviceName0("\\??\\" + fileName.substring(0, 2));
            if (deviceName == null) return null;
            if (!deviceName.startsWith(LANMAN_REDIRECTOR_PREFIX)) return deviceName + fileName.substring(2);
            int slashIndex = deviceName.indexOf(92, LANMAN_REDIRECTOR_PREFIX.length());
            if (slashIndex == -1) return null;
            return MUP_DEVICE_PATH + deviceName.substring(slashIndex) + fileName.substring(2);
        }
        if (!fileName.startsWith("\\\\")) return null;
        return MUP_DEVICE_PATH + fileName.substring(1);
    }

    public static void closeInheritedModulesHandle(LauncherLogger launcherLogger) {
        if (launcherLogger == null) {
            launcherLogger = LauncherLogger.STDERR_LOGGER;
        }
        try {
            List<FileHandle> handles = Win32Handle.list();
            if (handles != null) {
                File myModulesFile = LauncherUtil.isJava9Plus() ? new File(System.getProperty("java.home"), LIB_MODULES).getCanonicalFile() : null;
                String myModulesDeviceName = Win32Handle.getDevicePath(myModulesFile);
                if (myModulesFile != null && myModulesDeviceName == null) {
                    launcherLogger.error("could not get device name for module file " + myModulesFile);
                    return;
                }
                if (myModulesDeviceName != null) {
                    FileHandle handle2;
                    boolean myModuleFound = false;
                    Iterator<FileHandle> iterator2 = handles.iterator();
                    while (iterator2.hasNext() && !(myModuleFound = myModulesDeviceName.equals((handle2 = iterator2.next()).getDevicePath()))) {
                    }
                    if (!myModuleFound) {
                        launcherLogger.info("could not find own module file " + myModulesFile + ", " + myModulesDeviceName);
                        for (FileHandle handle2 : handles) {
                            launcherLogger.info(handle2.name + ", " + handle2.getDevicePath());
                        }
                        return;
                    }
                }
                launcherLogger.info("my modules file " + myModulesFile + ", " + myModulesDeviceName);
                for (FileHandle handle : handles) {
                    if (!handle.name.endsWith(LIB_MODULES) || myModulesDeviceName != null && myModulesDeviceName.equals(handle.getDevicePath())) continue;
                    if (!Win32Handle.close(handle)) {
                        launcherLogger.error("could not close module handle " + handle.name);
                        continue;
                    }
                    launcherLogger.info("closed inherited module handle " + handle.name);
                }
            }
        }
        catch (Throwable e) {
            launcherLogger.error(e);
        }
    }

    static {
        Common.init();
    }

    public static class FileHandle {
        public final int handle;
        public final String name;

        private FileHandle(int handle, String name) {
            this.handle = handle;
            this.name = name;
        }

        public String getDevicePath() {
            if (this.name != null && !this.name.startsWith("\\Device")) {
                String usedName = this.name;
                try {
                    usedName = new File(this.name).getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String withDeviceName = Win32Handle.getDevicePath(usedName);
                return withDeviceName != null ? withDeviceName : this.name;
            }
            return this.name;
        }

        public String toString() {
            return "FileHandle{handle=" + Integer.toHexString(this.handle) + ", name='" + this.name + '\'' + '}';
        }
    }
}

