Every exploit module has been assigned a rank based on its potential impact to the target system. Users can search, categorize, and prioritize exploits based on rankings.

The ranking is implemented by adding a `Rank` constant at the top of the class declaration in a module:

```ruby
class MetasploitModule < Msf::Exploit
    Rank = LowRanking
    def initialize(info={})
        ...
    end
    ...
end
```

The ranking values are one of the following, in descending order of reliability:

| Ranking              | Description |
| -------              | ----------- |
| **ExcellentRanking** | The exploit will never crash the service. This is the case for SQL Injection, CMD execution, RFI, LFI, etc. No typical memory corruption exploits should be given this ranking unless there are extraordinary circumstances ([WMF Escape()](https://github.com/rapid7/metasploit-framework/blob/master/modules/exploits/windows/browser/ms06_001_wmf_setabortproc.rb)). |
| **GreatRanking**     | The exploit has a default target AND either auto-detects the appropriate target or uses an application-specific return address AFTER a version check. |
| **GoodRanking**      | The exploit has a default target and it is the "common case" for this type of software (English, Windows 7 for a desktop app, 2012 for server, etc). Exploit does not auto-detect the target. |
| **NormalRanking**    | The exploit is otherwise reliable, but depends on a specific version that is not the "common case" for this type of software and can't (or doesn't) reliably autodetect. |
| **AverageRanking**   | The exploit is generally unreliable or difficult to exploit, but has a success rate of 50% or more for common platforms. |
| **LowRanking**       | The exploit is nearly impossible to exploit (under 50% success rate) for common platforms. |
| **ManualRanking**    | The exploit is unstable or difficult to exploit and is basically a DoS (15% success rate or lower). This ranking is also used when the module has no use unless specifically configured by the user (e.g.: [exploit/unix/webapp/php_eval](https://github.com/rapid7/metasploit-framework/blob/master/modules/exploits/unix/webapp/php_eval.rb)). |

The ranking value is available the module Class object as well as instances:

```ruby
modcls = framework.exploits["windows/browser/ie_createobject"]
modcls.rank      # => 600
modcls.rank_to_s # => "excellent"

mod = modcls.new
mod.rank      # => 600
mod.rank_to_s # => "excellent"
```