/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.cluster.DiskUsage;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.store.remote.filecache.AggregateFileCacheStats;
import org.opensearch.node.NodeResourceUsageStats;

@PublicApi(since="1.0.0")
public class ClusterInfo
implements ToXContentFragment,
Writeable {
    private final Map<String, DiskUsage> leastAvailableSpaceUsage;
    private final Map<String, DiskUsage> mostAvailableSpaceUsage;
    final Map<String, Long> shardSizes;
    public static final ClusterInfo EMPTY = new ClusterInfo();
    final Map<ShardRouting, String> routingToDataPath;
    final Map<NodeAndPath, ReservedSpace> reservedSpace;
    final Map<String, AggregateFileCacheStats> nodeFileCacheStats;
    private final Map<String, NodeResourceUsageStats> nodeResourceUsageStats;
    private long avgTotalBytes;
    private long avgFreeByte;

    protected ClusterInfo() {
        this(Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of());
    }

    @Deprecated(forRemoval=true)
    public ClusterInfo(Map<String, DiskUsage> leastAvailableSpaceUsage, Map<String, DiskUsage> mostAvailableSpaceUsage, Map<String, Long> shardSizes, Map<ShardRouting, String> routingToDataPath, Map<NodeAndPath, ReservedSpace> reservedSpace, Map<String, AggregateFileCacheStats> nodeFileCacheStats) {
        this(leastAvailableSpaceUsage, mostAvailableSpaceUsage, shardSizes, routingToDataPath, reservedSpace, nodeFileCacheStats, Map.of());
    }

    public ClusterInfo(Map<String, DiskUsage> leastAvailableSpaceUsage, Map<String, DiskUsage> mostAvailableSpaceUsage, Map<String, Long> shardSizes, Map<ShardRouting, String> routingToDataPath, Map<NodeAndPath, ReservedSpace> reservedSpace, Map<String, AggregateFileCacheStats> nodeFileCacheStats, Map<String, NodeResourceUsageStats> nodeResourceUsageStats) {
        this.leastAvailableSpaceUsage = leastAvailableSpaceUsage;
        this.shardSizes = shardSizes;
        this.mostAvailableSpaceUsage = mostAvailableSpaceUsage;
        this.routingToDataPath = routingToDataPath;
        this.reservedSpace = reservedSpace;
        this.nodeFileCacheStats = nodeFileCacheStats;
        this.nodeResourceUsageStats = nodeResourceUsageStats;
        this.calculateAvgFreeAndTotalBytes(mostAvailableSpaceUsage);
    }

    public ClusterInfo(StreamInput in) throws IOException {
        Map leastMap = in.readMap(StreamInput::readString, DiskUsage::new);
        Map mostMap = in.readMap(StreamInput::readString, DiskUsage::new);
        Map sizeMap = in.readMap(StreamInput::readString, StreamInput::readLong);
        Map routingMap = in.readMap(ShardRouting::new, StreamInput::readString);
        Map reservedSpaceMap = in.readMap(NodeAndPath::new, ReservedSpace::new);
        this.leastAvailableSpaceUsage = Collections.unmodifiableMap(leastMap);
        this.mostAvailableSpaceUsage = Collections.unmodifiableMap(mostMap);
        this.shardSizes = Collections.unmodifiableMap(sizeMap);
        this.routingToDataPath = Collections.unmodifiableMap(routingMap);
        this.reservedSpace = Collections.unmodifiableMap(reservedSpaceMap);
        this.nodeFileCacheStats = in.getVersion().onOrAfter(Version.V_2_10_0) ? in.readMap(StreamInput::readString, AggregateFileCacheStats::new) : Map.of();
        this.nodeResourceUsageStats = in.getVersion().onOrAfter(Version.V_3_2_0) ? in.readMap(StreamInput::readString, NodeResourceUsageStats::new) : Map.of();
        this.calculateAvgFreeAndTotalBytes(this.mostAvailableSpaceUsage);
    }

    private void calculateAvgFreeAndTotalBytes(Map<String, DiskUsage> usages) {
        if (usages == null || usages.isEmpty()) {
            this.avgTotalBytes = 0L;
            this.avgFreeByte = 0L;
            return;
        }
        long totalBytes = 0L;
        long freeBytes = 0L;
        for (DiskUsage du : usages.values()) {
            totalBytes += du.getTotalBytes();
            freeBytes += du.getFreeBytes();
        }
        this.avgTotalBytes = totalBytes / (long)usages.size();
        this.avgFreeByte = freeBytes / (long)usages.size();
    }

    public long getAvgFreeByte() {
        return this.avgFreeByte;
    }

    public long getAvgTotalBytes() {
        return this.avgTotalBytes;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.leastAvailableSpaceUsage, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        out.writeMap(this.mostAvailableSpaceUsage, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        out.writeMap(this.shardSizes, StreamOutput::writeString, (o, v) -> out.writeLong(v == null ? -1L : v));
        out.writeMap(this.routingToDataPath, (o, k) -> k.writeTo(o), StreamOutput::writeString);
        out.writeMap(this.reservedSpace, (o, v) -> v.writeTo(o), (o, v) -> v.writeTo(o));
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            out.writeMap(this.nodeFileCacheStats, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        }
        if (out.getVersion().onOrAfter(Version.V_3_2_0)) {
            out.writeMap(this.nodeResourceUsageStats, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (Map.Entry<String, DiskUsage> entry : this.leastAvailableSpaceUsage.entrySet()) {
            builder.startObject(entry.getKey());
            builder.field("node_name", entry.getValue().getNodeName());
            builder.startObject("least_available");
            entry.getValue().toShortXContent(builder);
            builder.endObject();
            builder.startObject("most_available");
            DiskUsage most = this.mostAvailableSpaceUsage.get(entry.getKey());
            if (most != null) {
                most.toShortXContent(builder);
            }
            builder.endObject();
            builder.startObject("node_resource_usage_stats");
            NodeResourceUsageStats resourceUsageStats = this.nodeResourceUsageStats.get(entry.getKey());
            if (resourceUsageStats != null) {
                resourceUsageStats.toXContent(builder, params);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        builder.startObject("shard_sizes");
        for (Map.Entry<String, Object> entry : this.shardSizes.entrySet()) {
            builder.humanReadableField(entry.getKey() + "_bytes", entry.getKey(), (Object)new ByteSizeValue(((Long)entry.getValue()).longValue()));
        }
        builder.endObject();
        builder.startObject("shard_paths");
        for (Map.Entry<Object, Object> entry : this.routingToDataPath.entrySet()) {
            builder.field(((ShardRouting)entry.getKey()).toString(), (String)entry.getValue());
        }
        builder.endObject();
        builder.startArray("reserved_sizes");
        for (Map.Entry<Object, Object> entry : this.reservedSpace.entrySet()) {
            builder.startObject();
            builder.field("node_id", ((NodeAndPath)entry.getKey()).nodeId);
            builder.field("path", ((NodeAndPath)entry.getKey()).path);
            ((ReservedSpace)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public Map<String, DiskUsage> getNodeLeastAvailableDiskUsages() {
        return Collections.unmodifiableMap(this.leastAvailableSpaceUsage);
    }

    public Map<String, DiskUsage> getNodeMostAvailableDiskUsages() {
        return Collections.unmodifiableMap(this.mostAvailableSpaceUsage);
    }

    public Map<String, AggregateFileCacheStats> getNodeFileCacheStats() {
        return Collections.unmodifiableMap(this.nodeFileCacheStats);
    }

    public Map<String, NodeResourceUsageStats> getNodeResourceUsageStats() {
        return Collections.unmodifiableMap(this.nodeResourceUsageStats);
    }

    public Long getShardSize(ShardRouting shardRouting) {
        return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(shardRouting));
    }

    public String getDataPath(ShardRouting shardRouting) {
        return this.routingToDataPath.get(shardRouting);
    }

    public long getShardSize(ShardRouting shardRouting, long defaultValue) {
        Long shardSize = this.getShardSize(shardRouting);
        return shardSize == null ? defaultValue : shardSize;
    }

    public ReservedSpace getReservedSpace(String nodeId, String dataPath) {
        ReservedSpace result = this.reservedSpace.get(new NodeAndPath(nodeId, dataPath));
        return result == null ? ReservedSpace.EMPTY : result;
    }

    static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return shardRouting.shardId().toString() + "[" + (shardRouting.primary() ? "p" : "r") + "]";
    }

    public static class NodeAndPath
    implements Writeable {
        public final String nodeId;
        public final String path;

        public NodeAndPath(String nodeId, String path) {
            this.nodeId = Objects.requireNonNull(nodeId);
            this.path = Objects.requireNonNull(path);
        }

        public NodeAndPath(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            this.path = in.readString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeAndPath that = (NodeAndPath)o;
            return this.nodeId.equals(that.nodeId) && this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.path);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.path);
        }
    }

    @PublicApi(since="1.0.0")
    public static class ReservedSpace
    implements Writeable {
        public static final ReservedSpace EMPTY = new ReservedSpace(0L, new HashSet<ShardId>());
        private final long total;
        private final Set<ShardId> shardIds;

        private ReservedSpace(long total, Set<ShardId> shardIds) {
            this.total = total;
            this.shardIds = Collections.unmodifiableSet(shardIds);
        }

        ReservedSpace(StreamInput in) throws IOException {
            this.total = in.readVLong();
            int shardIdCount = in.readVInt();
            HashSet<ShardId> shardIds = new HashSet<ShardId>(shardIdCount);
            for (int i = 0; i < shardIdCount; ++i) {
                shardIds.add(new ShardId(in));
            }
            this.shardIds = Collections.unmodifiableSet(shardIds);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.total);
            out.writeVInt(this.shardIds.size());
            for (ShardId shardIdCursor : this.shardIds) {
                shardIdCursor.writeTo(out);
            }
        }

        public long getTotal() {
            return this.total;
        }

        public boolean containsShardId(ShardId shardId) {
            return this.shardIds.contains(shardId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReservedSpace that = (ReservedSpace)o;
            return this.total == that.total && this.shardIds.equals(that.shardIds);
        }

        public int hashCode() {
            return Objects.hash(this.total, this.shardIds);
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            builder.startArray("shards");
            for (ShardId shardIdCursor : this.shardIds) {
                shardIdCursor.toXContent(builder, params);
            }
            builder.endArray();
        }

        public static class Builder {
            private long total;
            private Set<ShardId> shardIds = new HashSet<ShardId>();

            public ReservedSpace build() {
                assert (this.shardIds != null) : "already built";
                ReservedSpace reservedSpace = new ReservedSpace(this.total, this.shardIds);
                this.shardIds = null;
                return reservedSpace;
            }

            public Builder add(ShardId shardId, long reservedBytes) {
                assert (this.shardIds != null) : "already built";
                assert (reservedBytes >= 0L) : reservedBytes;
                this.shardIds.add(shardId);
                this.total += reservedBytes;
                return this;
            }
        }
    }
}

