/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.document.common;

import java.io.IOException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.protobufs.NullValue;
import org.opensearch.protobufs.ResponseItem;
import org.opensearch.protobufs.ShardInfo;
import org.opensearch.transport.grpc.proto.response.document.common.ShardInfoProtoUtils;

public class DocWriteResponseProtoUtils {
    private DocWriteResponseProtoUtils() {
    }

    public static ResponseItem.Builder toProto(DocWriteResponse response) throws IOException {
        ResponseItem.Builder responseItem = ResponseItem.newBuilder();
        responseItem.setIndex(response.getIndex());
        if (response.getId().isEmpty()) {
            responseItem.setId(ResponseItem.Id.newBuilder().setNullValue(NullValue.NULL_VALUE_NULL).build());
        } else {
            responseItem.setId(ResponseItem.Id.newBuilder().setString(response.getId()).build());
        }
        responseItem.setVersion(response.getVersion());
        responseItem.setResult(response.getResult().getLowercase());
        if (response.forcedRefresh()) {
            responseItem.setForcedRefresh(true);
        }
        ShardInfo shardInfo = ShardInfoProtoUtils.toProto(response.getShardInfo());
        responseItem.setShards(shardInfo);
        if (response.getSeqNo() >= 0L) {
            responseItem.setSeqNo(response.getSeqNo());
            responseItem.setPrimaryTerm(response.getPrimaryTerm());
        }
        return responseItem;
    }
}

