#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-LJBOOMGwL8K3A5QdtcAl79
key:                  postgrest-10.0.0-LJBOOMGwL8K3A5QdtcAl79
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  9023b9c7fda1cc6225b153fdced0f2bd
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-LJBOOMGwL8K3A5QdtcAl79
depends:
    HTTP-4000.4.1-I2GZEeEaB712x3GEu2mPEG
    Ranged-sets-0.5.0-6xAR5dO1DTNITrGk5D3D6L
    aeson-2.1.2.1-25X5lEqka86CxkXK2BMN9E
    auto-update-0.1.6-ArIdIHQixB23iUkw7hb3jb base-4.17.2.1
    base64-bytestring-1.2.1.0-LNkxyXoRMflHvQaufiNrDL
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-EW9gF4gHig7HSWPJPd5ucb
    cassava-0.5.4.1-HNI37QzPdXsHoieenbIR7e
    configurator-pg-0.2.10-5khFPU8qDxfJQ7clRtR4NB containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-Bb2zyDFdboi1bmTNGujhwK
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-H4zfTawwR2kCOAGIN1aXur
    hasql-dynamic-statements-0.3.1.1-5ek6pBRG8doDKm59BNXqDT
    hasql-notifications-0.2.0.5-5E9zEy6L4RbK85ENSkLxjJ
    hasql-pool-0.5.2.2-7ZJEbZo9NcX6FgLMX6kHnu
    hasql-transaction-1.0.1.1-57hyudHTfzm7fs618nIpBe
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-EwpVc2W1Y3M7oAuA2rwQwG
    insert-ordered-containers-0.2.5.3-1ci2HV4oem3E39sDrSeXlQ
    interpolatedstring-perl6-1.0.2-8OJ92W5WHkw7lvvsrjYA5X
    jose-0.10-5sMtJ9Gocq85kODBCg0VqV lens-5.3.2-Gri7akg07hN4ZkbavAwqWU
    lens-aeson-1.2.3-FcW5HsnpwRD27DF6jpPslU mtl-2.2.2
    network-3.1.4.0-4q2nDdk2jYz5m5sp4PhmqQ
    network-uri-2.6.4.2-9vKCxjgvNW3FsGV9sxXDe3
    optparse-applicative-0.18.1.0-EdEjIHpfurx5EyqDyJ3l4u
    parsec-3.1.16.1 protolude-0.3.5-CsiSm4e1K7v2rJxmM8DU6X
    regex-tdfa-1.3.2.4-Ehlt0m2SBCjGyOeVQxYb9I
    retry-0.9.3.1-83PkOW6VHGTLHLzIcnD9I6
    scientific-0.3.8.0-EroasVwH8ulAVKZ9SvWekK
    swagger2-2.8.10-GyC1VTrHzr4SvvRBoYKXd text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-DjNgsRwGYvfHy5WsKzKUzR
    vault-0.3.1.5-9SyJohcSNU92xs1AZ2XDax
    vector-0.13.2.0-FmAyOUuMvM2EH0h3dDhWXJ
    wai-3.2.4-Comuze1gXYWISk7kSVTjVQ
    wai-cors-0.2.7-6wGS84MZ7xFJWym1SwBMqO
    wai-extra-3.1.18-6v0GuSXVTNzCwydF3MlXZv
    wai-logger-2.5.0-2jZRa9K9mdG9KwHjbFk0fc
    warp-3.3.31-AFjtRrmm20A7xK9twGSdmw

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

