"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = register;
const language_service_1 = require("@volar/language-service");
const vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
const baseParse_1 = require("./baseParse");
function register(htmlLs) {
    return (pugCode) => {
        const parsed = (0, baseParse_1.baseParse)(pugCode);
        const htmlTextDocument = vscode_languageserver_textdocument_1.TextDocument.create('foo.html', 'html', 0, parsed.htmlCode);
        const htmlDocument = htmlLs.parseHTMLDocument(htmlTextDocument);
        const docs = [
            parsed.pugTextDocument,
            htmlTextDocument,
            (0, language_service_1.defaultMapperFactory)(parsed.mappings),
        ];
        return {
            ...parsed,
            htmlDocument,
            docs,
        };
    };
}
//# sourceMappingURL=pugDocument.js.map