/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim;

import io.sf.carte.echosvg.anim.AbstractAnimation;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.dom.AnimationTargetListener;
import io.sf.carte.echosvg.anim.timing.TimedDocumentRoot;
import io.sf.carte.echosvg.anim.timing.TimedElement;
import io.sf.carte.echosvg.anim.timing.TimegraphListener;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.util.DoublyIndexedTable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public abstract class AnimationEngine {
    public static final short ANIM_TYPE_XML = 0;
    public static final short ANIM_TYPE_CSS = 1;
    public static final short ANIM_TYPE_OTHER = 2;
    protected Document document;
    protected TimedDocumentRoot timedDocumentRoot;
    protected long pauseTime;
    protected HashMap<AnimationTarget, TargetInfo> targets = new HashMap();
    protected HashMap<AbstractAnimation, AnimationInfo> animations = new HashMap();
    protected Listener targetListener = new Listener();
    protected static final Map.Entry<AnimationTarget, TargetInfo>[] MAP_ENTRY_ARRAY = new Map.Entry[0];

    public AnimationEngine(Document document) {
        this.document = document;
        this.timedDocumentRoot = this.createDocumentRoot();
    }

    public void dispose() {
        for (Map.Entry<AnimationTarget, TargetInfo> entry : this.targets.entrySet()) {
            Sandwich sandwich;
            String string;
            Object object;
            Object object22;
            AnimationTarget animationTarget = entry.getKey();
            TargetInfo targetInfo = entry.getValue();
            for (Object object22 : targetInfo.xmlAnimations) {
                object = (String)object22.getKey1();
                string = (String)object22.getKey2();
                sandwich = (Sandwich)object22.getValue();
                if (!sandwich.listenerRegistered) continue;
                animationTarget.removeTargetListener((String)object, string, false, this.targetListener);
            }
            object22 = targetInfo.cssAnimations.entrySet().iterator();
            while (object22.hasNext()) {
                object = (Map.Entry)object22.next();
                string = (String)object.getKey();
                sandwich = (Sandwich)object.getValue();
                if (!sandwich.listenerRegistered) continue;
                animationTarget.removeTargetListener(null, string, true, this.targetListener);
            }
        }
    }

    public void pause() {
        if (this.pauseTime == 0L) {
            this.pauseTime = System.currentTimeMillis();
        }
    }

    public void unpause() {
        if (this.pauseTime != 0L) {
            Calendar calendar = this.timedDocumentRoot.getDocumentBeginTime();
            int n = (int)(System.currentTimeMillis() - this.pauseTime);
            calendar.add(14, n);
            this.pauseTime = 0L;
        }
    }

    public boolean isPaused() {
        return this.pauseTime != 0L;
    }

    public float getCurrentTime() {
        return this.timedDocumentRoot.getCurrentTime();
    }

    public float setCurrentTime(float f) {
        boolean bl = this.pauseTime != 0L;
        this.unpause();
        Calendar calendar = this.timedDocumentRoot.getDocumentBeginTime();
        float f2 = this.timedDocumentRoot.convertEpochTime(System.currentTimeMillis());
        calendar.add(14, (int)((f2 - f) * 1000.0f));
        if (bl) {
            this.pause();
        }
        return this.tick(f, true);
    }

    public void addAnimation(AnimationTarget animationTarget, short s, String string, String string2, AbstractAnimation abstractAnimation) {
        this.timedDocumentRoot.addChild(abstractAnimation.getTimedElement());
        AnimationInfo animationInfo = this.getAnimationInfo(abstractAnimation);
        animationInfo.type = s;
        animationInfo.attributeNamespaceURI = string;
        animationInfo.attributeLocalName = string2;
        animationInfo.target = animationTarget;
        this.animations.put(abstractAnimation, animationInfo);
        Sandwich sandwich = this.getSandwich(animationTarget, s, string, string2);
        if (sandwich.animation == null) {
            abstractAnimation.lowerAnimation = null;
            abstractAnimation.higherAnimation = null;
        } else {
            sandwich.animation.higherAnimation = abstractAnimation;
            abstractAnimation.lowerAnimation = sandwich.animation;
            abstractAnimation.higherAnimation = null;
        }
        sandwich.animation = abstractAnimation;
        if (abstractAnimation.lowerAnimation == null) {
            sandwich.lowestAnimation = abstractAnimation;
        }
    }

    public void removeAnimation(AbstractAnimation abstractAnimation) {
        this.timedDocumentRoot.removeChild(abstractAnimation.getTimedElement());
        AbstractAnimation abstractAnimation2 = abstractAnimation.higherAnimation;
        if (abstractAnimation2 != null) {
            abstractAnimation2.markDirty();
        }
        this.moveToBottom(abstractAnimation);
        if (abstractAnimation.higherAnimation != null) {
            abstractAnimation.higherAnimation.lowerAnimation = null;
        }
        AnimationInfo animationInfo = this.getAnimationInfo(abstractAnimation);
        Sandwich sandwich = this.getSandwich(animationInfo.target, animationInfo.type, animationInfo.attributeNamespaceURI, animationInfo.attributeLocalName);
        if (sandwich.animation == abstractAnimation) {
            sandwich.animation = null;
            sandwich.lowestAnimation = null;
            sandwich.shouldUpdate = true;
        }
    }

    protected Sandwich getSandwich(AnimationTarget animationTarget, short s, String string, String string2) {
        Sandwich sandwich;
        TargetInfo targetInfo = this.getTargetInfo(animationTarget);
        if (s == 0) {
            sandwich = (Sandwich)targetInfo.xmlAnimations.get((Object)string, (Object)string2);
            if (sandwich == null) {
                sandwich = new Sandwich();
                targetInfo.xmlAnimations.put((Object)string, (Object)string2, (Object)sandwich);
            }
        } else if (s == 1) {
            sandwich = targetInfo.cssAnimations.get(string2);
            if (sandwich == null) {
                sandwich = new Sandwich();
                targetInfo.cssAnimations.put(string2, sandwich);
            }
        } else {
            sandwich = targetInfo.otherAnimations.get(string2);
            if (sandwich == null) {
                sandwich = new Sandwich();
                targetInfo.otherAnimations.put(string2, sandwich);
            }
        }
        return sandwich;
    }

    protected TargetInfo getTargetInfo(AnimationTarget animationTarget) {
        TargetInfo targetInfo = this.targets.get(animationTarget);
        if (targetInfo == null) {
            targetInfo = new TargetInfo();
            this.targets.put(animationTarget, targetInfo);
        }
        return targetInfo;
    }

    protected AnimationInfo getAnimationInfo(AbstractAnimation abstractAnimation) {
        AnimationInfo animationInfo = this.animations.get(abstractAnimation);
        if (animationInfo == null) {
            animationInfo = new AnimationInfo();
            this.animations.put(abstractAnimation, animationInfo);
        }
        return animationInfo;
    }

    protected float tick(float f, boolean bl) {
        Map.Entry<AnimationTarget, TargetInfo>[] entryArray;
        float f2 = this.timedDocumentRoot.seekTo(f, bl);
        for (Map.Entry<AnimationTarget, TargetInfo> entry : entryArray = this.targets.entrySet().toArray(MAP_ENTRY_ARRAY)) {
            AbstractAnimation abstractAnimation;
            boolean bl2;
            AnimatableValue animatableValue;
            Sandwich sandwich;
            String string;
            Object object3;
            Object object22;
            AnimationTarget animationTarget = entry.getKey();
            TargetInfo targetInfo = entry.getValue();
            for (Object object22 : targetInfo.xmlAnimations) {
                object3 = (String)object22.getKey1();
                string = (String)object22.getKey2();
                sandwich = (Sandwich)object22.getValue();
                if (!sandwich.shouldUpdate && (sandwich.animation == null || !sandwich.animation.isDirty)) continue;
                animatableValue = null;
                bl2 = false;
                abstractAnimation = sandwich.animation;
                if (abstractAnimation != null) {
                    animatableValue = abstractAnimation.getComposedValue();
                    bl2 = sandwich.lowestAnimation.usesUnderlyingValue();
                    abstractAnimation.isDirty = false;
                }
                if (bl2 && !sandwich.listenerRegistered) {
                    animationTarget.addTargetListener((String)object3, string, false, this.targetListener);
                    sandwich.listenerRegistered = true;
                } else if (!bl2 && sandwich.listenerRegistered) {
                    animationTarget.removeTargetListener((String)object3, string, false, this.targetListener);
                    sandwich.listenerRegistered = false;
                }
                animationTarget.updateAttributeValue((String)object3, string, animatableValue);
                sandwich.shouldUpdate = false;
            }
            for (Object object3 : targetInfo.cssAnimations.entrySet()) {
                string = (String)object3.getKey();
                sandwich = (Sandwich)object3.getValue();
                if (!sandwich.shouldUpdate && (sandwich.animation == null || !sandwich.animation.isDirty)) continue;
                animatableValue = null;
                bl2 = false;
                abstractAnimation = sandwich.animation;
                if (abstractAnimation != null) {
                    animatableValue = abstractAnimation.getComposedValue();
                    bl2 = sandwich.lowestAnimation.usesUnderlyingValue();
                    abstractAnimation.isDirty = false;
                }
                if (bl2 && !sandwich.listenerRegistered) {
                    animationTarget.addTargetListener(null, string, true, this.targetListener);
                    sandwich.listenerRegistered = true;
                } else if (!bl2 && sandwich.listenerRegistered) {
                    animationTarget.removeTargetListener(null, string, true, this.targetListener);
                    sandwich.listenerRegistered = false;
                }
                if (bl2) {
                    animationTarget.updatePropertyValue(string, null);
                }
                if (!bl2 || animatableValue != null) {
                    animationTarget.updatePropertyValue(string, animatableValue);
                }
                sandwich.shouldUpdate = false;
            }
            object22 = targetInfo.otherAnimations.entrySet().iterator();
            while (object22.hasNext()) {
                object3 = (Map.Entry)object22.next();
                string = (String)object3.getKey();
                sandwich = (Sandwich)object3.getValue();
                if (!sandwich.shouldUpdate && (sandwich.animation == null || !sandwich.animation.isDirty)) continue;
                animatableValue = null;
                AbstractAnimation abstractAnimation2 = sandwich.animation;
                if (abstractAnimation2 != null) {
                    animatableValue = sandwich.animation.getComposedValue();
                    abstractAnimation2.isDirty = false;
                }
                animationTarget.updateOtherValue(string, animatableValue);
                sandwich.shouldUpdate = false;
            }
        }
        return f2;
    }

    public void toActive(AbstractAnimation abstractAnimation, float f) {
        this.moveToTop(abstractAnimation);
        abstractAnimation.isActive = true;
        abstractAnimation.beginTime = f;
        abstractAnimation.isFrozen = false;
        this.pushDown(abstractAnimation);
        abstractAnimation.markDirty();
    }

    protected void pushDown(AbstractAnimation abstractAnimation) {
        Object object;
        Object object2;
        TimedElement timedElement = abstractAnimation.getTimedElement();
        Object object3 = null;
        boolean bl = false;
        while (abstractAnimation.lowerAnimation != null && (abstractAnimation.lowerAnimation.isActive || abstractAnimation.lowerAnimation.isFrozen) && (abstractAnimation.lowerAnimation.beginTime > abstractAnimation.beginTime || abstractAnimation.lowerAnimation.beginTime == abstractAnimation.beginTime && timedElement.isBefore(abstractAnimation.lowerAnimation.getTimedElement()))) {
            object2 = abstractAnimation.higherAnimation;
            object = abstractAnimation.lowerAnimation;
            AbstractAnimation abstractAnimation2 = ((AbstractAnimation)object).lowerAnimation;
            if (object2 != null) {
                ((AbstractAnimation)object2).lowerAnimation = object;
            }
            if (abstractAnimation2 != null) {
                abstractAnimation2.higherAnimation = abstractAnimation;
            }
            ((AbstractAnimation)object).lowerAnimation = abstractAnimation;
            ((AbstractAnimation)object).higherAnimation = object2;
            abstractAnimation.lowerAnimation = abstractAnimation2;
            abstractAnimation.higherAnimation = object;
            if (bl) continue;
            object3 = object;
            bl = true;
        }
        if (bl) {
            object2 = this.getAnimationInfo(abstractAnimation);
            object = this.getSandwich(((AnimationInfo)object2).target, ((AnimationInfo)object2).type, ((AnimationInfo)object2).attributeNamespaceURI, ((AnimationInfo)object2).attributeLocalName);
            if (((Sandwich)object).animation == abstractAnimation) {
                ((Sandwich)object).animation = object3;
            }
            if (abstractAnimation.lowerAnimation == null) {
                ((Sandwich)object).lowestAnimation = abstractAnimation;
            }
        }
    }

    public void toInactive(AbstractAnimation abstractAnimation, boolean bl) {
        abstractAnimation.isActive = false;
        abstractAnimation.isFrozen = bl;
        abstractAnimation.markDirty();
        if (!bl) {
            abstractAnimation.value = null;
            abstractAnimation.beginTime = Float.NEGATIVE_INFINITY;
            this.moveToBottom(abstractAnimation);
        }
    }

    public void removeFill(AbstractAnimation abstractAnimation) {
        abstractAnimation.isActive = false;
        abstractAnimation.isFrozen = false;
        abstractAnimation.value = null;
        abstractAnimation.markDirty();
        this.moveToBottom(abstractAnimation);
    }

    protected void moveToTop(AbstractAnimation abstractAnimation) {
        AnimationInfo animationInfo = this.getAnimationInfo(abstractAnimation);
        Sandwich sandwich = this.getSandwich(animationInfo.target, animationInfo.type, animationInfo.attributeNamespaceURI, animationInfo.attributeLocalName);
        sandwich.shouldUpdate = true;
        if (abstractAnimation.higherAnimation == null) {
            return;
        }
        if (abstractAnimation.lowerAnimation == null) {
            sandwich.lowestAnimation = abstractAnimation.higherAnimation;
        } else {
            abstractAnimation.lowerAnimation.higherAnimation = abstractAnimation.higherAnimation;
        }
        abstractAnimation.higherAnimation.lowerAnimation = abstractAnimation.lowerAnimation;
        if (sandwich.animation != null) {
            sandwich.animation.higherAnimation = abstractAnimation;
        }
        abstractAnimation.lowerAnimation = sandwich.animation;
        abstractAnimation.higherAnimation = null;
        sandwich.animation = abstractAnimation;
    }

    protected void moveToBottom(AbstractAnimation abstractAnimation) {
        if (abstractAnimation.lowerAnimation == null) {
            return;
        }
        AnimationInfo animationInfo = this.getAnimationInfo(abstractAnimation);
        Sandwich sandwich = this.getSandwich(animationInfo.target, animationInfo.type, animationInfo.attributeNamespaceURI, animationInfo.attributeLocalName);
        AbstractAnimation abstractAnimation2 = abstractAnimation.lowerAnimation;
        abstractAnimation2.markDirty();
        abstractAnimation.lowerAnimation.higherAnimation = abstractAnimation.higherAnimation;
        if (abstractAnimation.higherAnimation != null) {
            abstractAnimation.higherAnimation.lowerAnimation = abstractAnimation.lowerAnimation;
        } else {
            sandwich.animation = abstractAnimation2;
            sandwich.shouldUpdate = true;
        }
        sandwich.lowestAnimation.lowerAnimation = abstractAnimation;
        abstractAnimation.higherAnimation = sandwich.lowestAnimation;
        abstractAnimation.lowerAnimation = null;
        sandwich.lowestAnimation = abstractAnimation;
        if (sandwich.animation.isDirty) {
            sandwich.shouldUpdate = true;
        }
    }

    public void addTimegraphListener(TimegraphListener timegraphListener) {
        this.timedDocumentRoot.addTimegraphListener(timegraphListener);
    }

    public void removeTimegraphListener(TimegraphListener timegraphListener) {
        this.timedDocumentRoot.removeTimegraphListener(timegraphListener);
    }

    public void sampledAt(AbstractAnimation abstractAnimation, float f, float f2, int n) {
        abstractAnimation.sampledAt(f, f2, n);
    }

    public void sampledLastValue(AbstractAnimation abstractAnimation, int n) {
        abstractAnimation.sampledLastValue(n);
    }

    protected abstract TimedDocumentRoot createDocumentRoot();

    protected static class AnimationInfo {
        public AnimationTarget target;
        public short type;
        public String attributeNamespaceURI;
        public String attributeLocalName;

        protected AnimationInfo() {
        }
    }

    protected class Listener
    implements AnimationTargetListener {
        protected Listener() {
        }

        @Override
        public void baseValueChanged(AnimationTarget animationTarget, String string, String string2, boolean bl) {
            short s = bl ? (short)1 : 0;
            Sandwich sandwich = AnimationEngine.this.getSandwich(animationTarget, s, string, string2);
            sandwich.shouldUpdate = true;
            AbstractAnimation abstractAnimation = sandwich.animation;
            while (abstractAnimation.lowerAnimation != null) {
                abstractAnimation = abstractAnimation.lowerAnimation;
            }
            abstractAnimation.markDirty();
        }
    }

    protected static class Sandwich {
        public AbstractAnimation animation;
        public AbstractAnimation lowestAnimation;
        public boolean shouldUpdate;
        public boolean listenerRegistered;

        protected Sandwich() {
        }
    }

    protected static class TargetInfo {
        public DoublyIndexedTable<String, String> xmlAnimations = new DoublyIndexedTable();
        public HashMap<String, Sandwich> cssAnimations = new HashMap();
        public HashMap<String, Sandwich> otherAnimations = new HashMap();

        protected TargetInfo() {
        }
    }
}

