/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSCounterStyleRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class CounterStyleRule
extends BaseCSSDeclarationRule
implements CSSCounterStyleRule {
    private static final long serialVersionUID = 1L;
    private String name = null;

    public CounterStyleRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)11, by);
    }

    @Override
    public String getName() {
        return ParseHelper.escape(this.name);
    }

    void setName(String string) throws DOMException {
        if ((string = ParseHelper.parseIdent(string)) == null || "none".equalsIgnoreCase(string) || "disc".equalsIgnoreCase(string) || "decimal".equalsIgnoreCase(string) || "inside".equalsIgnoreCase(string) || "outside".equalsIgnoreCase(string) || "inherit".equalsIgnoreCase(string) || "unset".equalsIgnoreCase(string) || "initial".equalsIgnoreCase(string) || "revert".equalsIgnoreCase(string)) {
            throw new DOMException(12, "Bad counter-style name: " + string);
        }
        this.name = string;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.name != null || this.getStyle().getLength() != 0) {
            return "@counter-style " + this.getName() + " {" + this.getStyle().getMinifiedCssText() + '}';
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        if (this.name != null || this.getStyle().getLength() != 0) {
            styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
            simpleWriter.write((CharSequence)"@counter-style ");
            simpleWriter.write((CharSequence)this.getName());
            styleFormattingContext.updateContext(this);
            styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
            styleFormattingContext.startStyleDeclaration(simpleWriter);
            this.getStyle().writeCssText(simpleWriter, styleFormattingContext);
            styleFormattingContext.endCurrentContext(this);
            styleFormattingContext.endStyleDeclaration(simpleWriter);
            styleFormattingContext.writeRightCurlyBracket(simpleWriter);
            styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
        }
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        super.setRule(abstractCSSRule);
        this.name = ((CounterStyleRule)abstractCSSRule).name;
    }

    @Override
    void startAtRule(String string, String string2) {
        if (!"counter-style".equalsIgnoreCase(string)) {
            throw new DOMException(13, "Cannot set rule of type: " + string);
        }
        if (string2 == null) {
            throw new DOMException(12, "No counter-style name.");
        }
        this.setName(string2.trim());
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.getType();
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CounterStyleRule counterStyleRule = (CounterStyleRule)object;
        return !(this.name == null ? counterStyleRule.name != null : !this.name.equals(counterStyleRule.name));
    }

    @Override
    public CounterStyleRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        CounterStyleRule counterStyleRule = new CounterStyleRule(abstractCSSStyleSheet, this.getOrigin());
        counterStyleRule.setName(this.getName());
        String string = this.getParentStyleSheet().getHref();
        counterStyleRule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), string);
        return counterStyleRule;
    }
}

