/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public abstract class IdentifierManager
extends AbstractValueManager {
    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                String string = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT).intern();
                Object object = this.getIdentifiers().get(string);
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
                }
                return (Value)object;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lexicalUnit);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String string, CSSEngine cSSEngine) throws DOMException {
        if (type != CSSValue.Type.IDENT) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        Object object = this.getIdentifiers().get(string.toLowerCase(Locale.ROOT).intern());
        if (object == null) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return (Value)object;
    }

    public abstract StringMap getIdentifiers();
}

