/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.common.nio.Buffers;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.Shape;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.PinchToZoomGesture;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.Recti;
import com.jogamp.opengl.math.Vec2f;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.PMVMatrix;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import jogamp.graph.ui.TreeTool;

public final class Scene
implements Container,
GLEventListener {
    public static final float DEFAULT_SCENE_DIST = -0.2f;
    public static final float DEFAULT_ANGLE = 45.0f;
    public static final float DEFAULT_ZNEAR = 0.1f;
    public static final float DEFAULT_ZFAR = 7000.0f;
    private static final boolean DEBUG = false;
    private final List<Shape> shapes = new ArrayList<Shape>();
    private float dbgBorderThickness = 0.0f;
    private boolean doFrustumCulling = false;
    private float[] clearColor = null;
    private int clearMask;
    private final RegionRenderer renderer;
    private final int[] sampleCount = new int[1];
    private final AABBox planeBox = new AABBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private volatile Shape activeShape = null;
    private SBCMouseListener sbcMouseListener = null;
    private SBCGestureListener sbcGestureListener = null;
    private PinchToZoomGesture pinchToZoomGesture = null;
    final GLReadBufferUtil screenshot;
    private GLAutoDrawable cDrawable = null;
    private static final int[] sampleCountGLSelect = new int[]{-1};
    private volatile boolean displayedOnce = false;
    private final Object syncDisplayedOnce = new Object();
    private int screenShotCount = 0;
    private static final PMVMatrixSetup defaultPMVMatrixSetup = new PMVMatrixSetup(){

        @Override
        public void set(PMVMatrix pMVMatrix, Recti recti) {
            float f = (float)recti.width() / (float)recti.height();
            pMVMatrix.glMatrixMode(5889);
            pMVMatrix.glLoadIdentity();
            pMVMatrix.gluPerspective(45.0f, f, 0.1f, 7000.0f);
            pMVMatrix.glTranslatef(0.0f, 0.0f, -0.2f);
            pMVMatrix.glMatrixMode(5888);
            pMVMatrix.glLoadIdentity();
            AABBox aABBox = new AABBox();
            this.setPlaneBox(aABBox, pMVMatrix, recti);
            float f2 = aABBox.getWidth();
            float f3 = aABBox.getHeight();
            float f4 = f2 > f3 ? f2 : f3;
            pMVMatrix.glMatrixMode(5889);
            pMVMatrix.glScalef(f4, f4, 1.0f);
            pMVMatrix.glMatrixMode(5888);
        }

        @Override
        public void setPlaneBox(AABBox aABBox, PMVMatrix pMVMatrix, Recti recti) {
            Vec3f vec3f = new Vec3f();
            Vec3f vec3f2 = new Vec3f();
            Scene.winToPlaneCoord(pMVMatrix, recti, 0.1f, 7000.0f, recti.x(), recti.y(), 0.2f, vec3f);
            Scene.winToPlaneCoord(pMVMatrix, recti, 0.1f, 7000.0f, recti.width(), recti.height(), 0.2f, vec3f2);
            aABBox.setSize(vec3f, vec3f2);
        }
    };
    private PMVMatrixSetup pmvMatrixSetup = defaultPMVMatrixSetup;

    private static RegionRenderer createRenderer() {
        return RegionRenderer.create(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
    }

    public Scene() {
        this(Scene.createRenderer());
    }

    public Scene(RegionRenderer regionRenderer) {
        if (null == regionRenderer) {
            throw new IllegalArgumentException("Null RegionRenderer");
        }
        this.renderer = regionRenderer;
        this.sampleCount[0] = 4;
        this.screenshot = new GLReadBufferUtil(false, false);
    }

    public RegionRenderer getRenderer() {
        return this.renderer;
    }

    public final void setClearParams(float[] fArray, int n) {
        this.clearColor = fArray;
        this.clearMask = n;
    }

    public final float[] getClearColor() {
        return this.clearColor;
    }

    public final int getClearMask() {
        return this.clearMask;
    }

    @Override
    public final void setFrustumCullingEnabled(boolean bl) {
        this.doFrustumCulling = bl;
    }

    @Override
    public final boolean isFrustumCullingEnabled() {
        return this.doFrustumCulling;
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.sbcMouseListener) {
            this.sbcMouseListener = new SBCMouseListener();
            gLWindow.addMouseListener(this.sbcMouseListener);
            this.sbcGestureListener = new SBCGestureListener();
            gLWindow.addGestureListener(this.sbcGestureListener);
            this.pinchToZoomGesture = new PinchToZoomGesture(gLWindow.getNativeSurface(), false);
            gLWindow.addGestureHandler(this.pinchToZoomGesture);
        }
    }

    public void detachInputListenerFrom(GLWindow gLWindow) {
        if (null != this.sbcMouseListener) {
            gLWindow.removeMouseListener(this.sbcMouseListener);
            this.sbcMouseListener = null;
            gLWindow.removeGestureListener(this.sbcGestureListener);
            this.sbcGestureListener = null;
            gLWindow.removeGestureHandler(this.pinchToZoomGesture);
            this.pinchToZoomGesture = null;
        }
    }

    @Override
    public List<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    public void addShape(Shape shape) {
        shape.setBorder(this.dbgBorderThickness);
        this.shapes.add(shape);
    }

    @Override
    public Shape removeShape(Shape shape) {
        shape.setBorder(0.0f);
        return this.shapes.remove(shape) ? shape : null;
    }

    @Override
    public Shape removeShape(int n) {
        return this.shapes.remove(n);
    }

    public void removeShape(GL2ES2 gL2ES2, Shape shape) {
        shape.setBorder(0.0f);
        this.shapes.remove(shape);
        shape.destroy(gL2ES2, this.renderer);
    }

    @Override
    public void addShapes(Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.addShape(shape);
        }
    }

    @Override
    public void removeShapes(Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.removeShape(shape);
        }
    }

    public void removeShapes(GL2ES2 gL2ES2, Collection<? extends Shape> collection) {
        for (Shape shape : collection) {
            this.removeShape(gL2ES2, shape);
        }
    }

    @Override
    public void removeAllShapes() {
        this.shapes.clear();
    }

    public void removeAllShapes(GL2ES2 gL2ES2) {
        int n = this.shapes.size();
        for (int i = n - 1; i >= 0; --i) {
            this.removeShape(gL2ES2, this.shapes.get(i));
        }
    }

    @Override
    public boolean contains(Shape shape) {
        return false;
    }

    public Shape getShapeByIdx(int n) {
        if (0 > n) {
            return null;
        }
        return this.shapes.get(n);
    }

    public Shape getShapeByName(int n) {
        for (Shape shape : this.shapes) {
            if (shape.getName() != n) continue;
            return shape;
        }
        return null;
    }

    public int getSampleCount() {
        return this.sampleCount[0];
    }

    public int setSampleCount(int n) {
        this.sampleCount[0] = Math.min(8, Math.max(n, 0));
        this.markAllShapesDirty();
        return this.sampleCount[0];
    }

    public void setAllShapesQuality(int n) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            Shape shape = this.shapes.get(i);
            if (!(shape instanceof GraphShape)) continue;
            ((GraphShape)shape).setQuality(n);
        }
    }

    public void setAllShapesSharpness(float f) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            Shape shape = this.shapes.get(i);
            if (!(shape instanceof GraphShape)) continue;
            ((GraphShape)shape).setSharpness(f);
        }
    }

    public void markAllShapesDirty() {
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).markShapeDirty();
        }
    }

    public final void setDebugBorderBox(float f) {
        this.dbgBorderThickness = f;
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).setBorder(f);
        }
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        this.cDrawable = gLAutoDrawable;
        this.renderer.init(gLAutoDrawable.getGL().getGL2ES2());
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.renderer.reshapeNotify(n, n2, n3, n4);
        this.setupMatrix(this.renderer.getMatrix(), this.renderer.getViewport());
        this.pmvMatrixSetup.setPlaneBox(this.planeBox, this.renderer.getMatrix(), this.renderer.getViewport());
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        Object[] objectArray = this.shapes.toArray();
        Arrays.sort(objectArray, Shape.ZAscendingComparator);
        this.display(gLAutoDrawable, objectArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void display(GLAutoDrawable gLAutoDrawable, Object[] objectArray, boolean bl) {
        int[] nArray;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (bl) {
            gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            nArray = sampleCountGLSelect;
            gL2ES2.glClear(16640);
        } else {
            if (null != this.clearColor) {
                gL2ES2.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
                gL2ES2.glClear(this.clearMask);
            }
            nArray = this.sampleCount;
        }
        PMVMatrix pMVMatrix = this.renderer.getMatrix();
        pMVMatrix.glMatrixMode(5888);
        if (bl) {
            this.renderer.enable(gL2ES2, true, RegionRenderer.defaultBlendDisable, RegionRenderer.defaultBlendDisable);
        } else {
            this.renderer.enable(gL2ES2, true);
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Shape shape = (Shape)objectArray[i];
            if (!shape.isEnabled()) continue;
            pMVMatrix.glPushMatrix();
            shape.setTransform(pMVMatrix);
            if (!this.doFrustumCulling || !pMVMatrix.getFrustum().isAABBoxOutside(shape.getBounds())) {
                if (bl) {
                    float f = ((float)i + 1.0f) / ((float)n + 2.0f);
                    this.renderer.setColorStatic(f, f, f, 1.0f);
                    shape.drawToSelect(gL2ES2, this.renderer, nArray);
                } else {
                    shape.draw(gL2ES2, this.renderer, nArray);
                }
            }
            pMVMatrix.glPopMatrix();
        }
        if (bl) {
            this.renderer.enable(gL2ES2, false, RegionRenderer.defaultBlendDisable, RegionRenderer.defaultBlendDisable);
        } else {
            this.renderer.enable(gL2ES2, false);
        }
        Object object = this.syncDisplayedOnce;
        synchronized (object) {
            this.displayedOnce = true;
            this.syncDisplayedOnce.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDisplayed() {
        Object object = this.syncDisplayedOnce;
        synchronized (object) {
            while (!this.displayedOnce) {
                try {
                    this.syncDisplayedOnce.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        Object object = this.syncDisplayedOnce;
        synchronized (object) {
            this.displayedOnce = false;
            this.syncDisplayedOnce.notifyAll();
        }
        if (gLAutoDrawable instanceof GLWindow) {
            object = (GLWindow)gLAutoDrawable;
            this.detachInputListenerFrom((GLWindow)object);
        }
        object = gLAutoDrawable.getGL().getGL2ES2();
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).destroy((GL2ES2)object, this.renderer);
        }
        this.shapes.clear();
        this.cDrawable = null;
        this.renderer.destroy((GL2ES2)object);
        this.screenshot.dispose((GL)object);
    }

    public Shape pickShape(PMVMatrix pMVMatrix, int n, int n2, Vec3f vec3f, Shape[] shapeArray, Runnable runnable) {
        this.setupMatrix(pMVMatrix);
        Recti recti = this.getViewport();
        Ray ray = new Ray();
        shapeArray[0] = null;
        this.forSortedAll(Shape.ZAscendingComparator, pMVMatrix, (shape, pMVMatrix2) -> {
            AABBox aABBox;
            boolean bl;
            boolean bl2 = bl = shape.isInteractive() && pMVMatrix.gluUnProjectRay(n, n2, 0.0f, 0.3f, recti, ray);
            if (bl && (aABBox = shape.getBounds()).intersectsRay(ray)) {
                if (null == aABBox.getRayIntersection(vec3f, ray, 1.1920929E-7f, true)) {
                    throw new InternalError("Ray " + ray + ", box " + aABBox);
                }
                shapeArray[0] = shape;
                runnable.run();
                return true;
            }
            return false;
        });
        return shapeArray[0];
    }

    public void pickShapeGL(final int n, final int n2, final Vec3f vec3f, final Shape[] shapeArray, final Runnable runnable) {
        if (null == this.cDrawable) {
            return;
        }
        this.cDrawable.invoke(false, new GLRunnable(){

            @Override
            public boolean run(GLAutoDrawable gLAutoDrawable) {
                Shape shape;
                shapeArray[0] = shape = Scene.this.pickShapeGLImpl(gLAutoDrawable, n, n2);
                if (null != shape) {
                    PMVMatrix pMVMatrix = Scene.this.renderer.getMatrix();
                    pMVMatrix.glPushMatrix();
                    shape.setTransform(pMVMatrix);
                    boolean bl = null != shapeArray[0].winToShapeCoord(Scene.this.getMatrix(), Scene.this.getViewport(), n, n2, vec3f);
                    pMVMatrix.glPopMatrix();
                    if (bl) {
                        runnable.run();
                    }
                }
                return false;
            }
        });
    }

    private Shape pickShapeGLImpl(GLAutoDrawable gLAutoDrawable, int n, int n2) {
        Object[] objectArray = this.shapes.toArray();
        Arrays.sort(objectArray, Shape.ZAscendingComparator);
        GLPixelStorageModes gLPixelStorageModes = new GLPixelStorageModes();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)4);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.display(gLAutoDrawable, objectArray, true);
        gLPixelStorageModes.setPackAlignment(gL2ES2, 4);
        try {
            gL2ES2.glReadPixels(n, n2, 1, 1, 6408, 5121, byteBuffer);
        }
        catch (GLException gLException) {
            gLException.printStackTrace();
            return null;
        }
        gLPixelStorageModes.restore(gL2ES2);
        int n3 = this.shapes.size();
        int n4 = byteBuffer.get(0) & 0xFF;
        float f = (float)n4 / 255.0f;
        int n5 = Math.round(f * ((float)n3 + 2.0f) - 1.0f);
        System.err.printf("pickGL: glWin %d / %d, byte %d, color %f, index %d of [0..%d[%n", n, n2, n4, Float.valueOf(f), n5, n3);
        if (0 <= n5 && n5 < n3) {
            return (Shape)objectArray[n5];
        }
        return null;
    }

    public void winToShapeCoord(Shape shape, int n, int n2, PMVMatrix pMVMatrix, Vec3f vec3f, Runnable runnable) {
        if (null == shape) {
            return;
        }
        Recti recti = this.getViewport();
        this.setupMatrix(pMVMatrix);
        this.forOne(pMVMatrix, shape, () -> {
            if (null != shape.winToShapeCoord(pMVMatrix, recti, n, n2, vec3f)) {
                runnable.run();
            }
        });
    }

    @Override
    public AABBox getBounds(PMVMatrix pMVMatrix, Shape shape) {
        AABBox aABBox = new AABBox();
        if (null == shape) {
            return aABBox;
        }
        this.setupMatrix(pMVMatrix);
        this.forOne(pMVMatrix, shape, () -> shape.getBounds().transformMv(pMVMatrix, aABBox));
        return aABBox;
    }

    @Override
    public boolean forOne(PMVMatrix pMVMatrix, Shape shape, Runnable runnable) {
        return TreeTool.forOne(this.shapes, pMVMatrix, shape, runnable);
    }

    @Override
    public boolean forAll(PMVMatrix pMVMatrix, Shape.Visitor2 visitor2) {
        return TreeTool.forAll(this.shapes, pMVMatrix, visitor2);
    }

    @Override
    public boolean forAll(Shape.Visitor1 visitor1) {
        return TreeTool.forAll(this.shapes, visitor1);
    }

    @Override
    public boolean forSortedAll(Comparator<Shape> comparator, PMVMatrix pMVMatrix, Shape.Visitor2 visitor2) {
        return TreeTool.forSortedAll(comparator, this.shapes, pMVMatrix, visitor2);
    }

    public final PMVMatrixSetup getPMVMatrixSetup() {
        return this.pmvMatrixSetup;
    }

    public final void setPMVMatrixSetup(PMVMatrixSetup pMVMatrixSetup) {
        this.pmvMatrixSetup = pMVMatrixSetup;
    }

    public static PMVMatrixSetup getDefaultPMVMatrixSetup() {
        return defaultPMVMatrixSetup;
    }

    public void setupMatrix(PMVMatrix pMVMatrix, Recti recti) {
        this.pmvMatrixSetup.set(pMVMatrix, recti);
    }

    public void setupMatrix(PMVMatrix pMVMatrix) {
        Recti recti = this.renderer.getViewport();
        this.setupMatrix(pMVMatrix, recti);
    }

    public final Recti getViewport(Recti recti) {
        return this.renderer.getViewport(recti);
    }

    public Recti getViewport() {
        return this.renderer.getViewport();
    }

    public int getWidth() {
        return this.renderer.getWidth();
    }

    public int getHeight() {
        return this.renderer.getHeight();
    }

    public PMVMatrix getMatrix() {
        return this.renderer.getMatrix();
    }

    public AABBox getBounds() {
        return this.planeBox;
    }

    public static void winToPlaneCoord(PMVMatrix pMVMatrix, Recti recti, float f, float f2, float f3, float f4, float f5, Vec3f vec3f) {
        float f6 = FloatUtil.getOrthoWinZ(f5, f, f2);
        pMVMatrix.gluUnProject(f3, f4, f6, recti, vec3f);
    }

    public void surfaceToPlaneSize(Recti recti, float f, float f2, float f3, Vec2f vec2f) {
        PMVMatrix pMVMatrix = new PMVMatrix();
        this.setupMatrix(pMVMatrix, recti);
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        Scene.winToPlaneCoord(pMVMatrix, recti, 0.1f, 7000.0f, recti.x(), recti.y(), f3, vec3f);
        Scene.winToPlaneCoord(pMVMatrix, recti, 0.1f, 7000.0f, recti.width(), recti.height(), f3, vec3f2);
        vec2f.set(vec3f2.x() - vec3f.x(), vec3f2.y() - vec3f.y());
    }

    public void surfaceToPlaneSize(Recti recti, Vec2f vec2f) {
        this.surfaceToPlaneSize(recti, 0.1f, 7000.0f, 0.2f, vec2f);
    }

    public final Shape getActiveShape() {
        return this.activeShape;
    }

    public void releaseActiveShape() {
        this.activeShape = null;
    }

    private void setActiveShape(Shape shape) {
        this.activeShape = shape;
    }

    final void dispatchMouseEvent(MouseEvent mouseEvent, int n, int n2) {
        if (null == this.activeShape) {
            this.dispatchMouseEventPickShape(mouseEvent, n, n2);
        } else if (this.activeShape.isInteractive()) {
            this.dispatchMouseEventForShape(this.activeShape, mouseEvent, n, n2);
        }
    }

    final void dispatchMouseEventPickShape(MouseEvent mouseEvent, int n, int n2) {
        PMVMatrix pMVMatrix = new PMVMatrix();
        Vec3f vec3f = new Vec3f();
        Shape[] shapeArray = new Shape[]{null};
        if (null == this.pickShape(pMVMatrix, n, n2, vec3f, shapeArray, () -> {
            this.setActiveShape(shapeArray[0]);
            shapeArray[0].dispatchMouseEvent(mouseEvent, n, n2, vec3f);
        })) {
            this.releaseActiveShape();
        }
    }

    final void dispatchMouseEventForShape(Shape shape, MouseEvent mouseEvent, int n, int n2) {
        PMVMatrix pMVMatrix = new PMVMatrix();
        Vec3f vec3f = new Vec3f();
        this.winToShapeCoord(shape, n, n2, pMVMatrix, vec3f, () -> shape.dispatchMouseEvent(mouseEvent, n, n2, vec3f));
    }

    public String getStatusText(GLAutoDrawable gLAutoDrawable, int n, int n2, float f) {
        float f2;
        float f3;
        float f4;
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        if (null != gLAnimatorControl) {
            f4 = gLAnimatorControl.getLastFPS();
            f3 = gLAnimatorControl.getTotalFPS();
            f2 = (float)gLAnimatorControl.getLastFPSPeriod() / (float)gLAnimatorControl.getUpdateFPSFrames();
        } else {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLAutoDrawable.getChosenGLCapabilities();
        String string = Region.getRenderModeString(n, this.getSampleCount(), gLCapabilitiesImmutable.getNumSamples());
        String string2 = 0 <= n2 ? ", q " + n2 : "";
        String string3 = this.getRenderer().isHintMaskSet(1) ? ", blend" : "";
        return String.format("%03.1f/%03.1f fps, %.1f ms/f, vsync %d, dpi %.1f, %s%s%s, a %d", Float.valueOf(f4), Float.valueOf(f3), Float.valueOf(f2), gLAutoDrawable.getGL().getSwapInterval(), Float.valueOf(f), string, string2, string3, gLCapabilitiesImmutable.getAlphaBits());
    }

    public static String getStatusText(FPSCounter fPSCounter) {
        float f = fPSCounter.getLastFPS();
        float f2 = fPSCounter.getTotalFPS();
        float f3 = (float)fPSCounter.getLastFPSPeriod() / (float)fPSCounter.getUpdateFPSFrames();
        return String.format("%03.1f/%03.1f fps, %.1f ms/f", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3));
    }

    public File nextScreenshotFile(String string, String string2, int n, GLCapabilitiesImmutable gLCapabilitiesImmutable, String string3) {
        String string4 = null != string && string.length() > 0 ? string : "";
        String string5 = null != string2 && string2.length() > 0 ? string2 + "-" : "";
        RegionRenderer regionRenderer = this.getRenderer();
        String string6 = Region.getRenderModeString(n, this.getSampleCount(), gLCapabilitiesImmutable.getNumSamples());
        String string7 = null != string3 && string3.length() > 0 ? string3 + "-" : "";
        return new File(String.format((Locale)null, "%s%s%s-%ssnap%02d-%04dx%04d.png", string4, string5, string6, string7, this.screenShotCount++, regionRenderer.getWidth(), regionRenderer.getHeight()));
    }

    public int getScreenshotCount() {
        return this.screenShotCount;
    }

    public void screenshot(GL gL, File file) {
        if (this.screenshot.readPixels(gL, false)) {
            this.screenshot.write(file);
            System.err.println("Wrote: " + file);
        }
    }

    public void screenshot(boolean bl, File file) {
        if (null != this.cDrawable) {
            this.cDrawable.invoke(bl, gLAutoDrawable -> {
                this.screenshot(gLAutoDrawable.getGL(), file);
                return true;
            });
        }
    }

    public static interface PMVMatrixSetup {
        public void set(PMVMatrix var1, Recti var2);

        public void setPlaneBox(AABBox var1, PMVMatrix var2, Recti var3);
    }

    private final class SBCGestureListener
    implements GestureHandler.GestureListener {
        private SBCGestureListener() {
        }

        @Override
        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
            Shape shape;
            InputEvent inputEvent;
            if (null != Scene.this.activeShape && (inputEvent = gestureEvent.getTrigger()) instanceof MouseEvent && (shape = Scene.this.activeShape).isInteractive()) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                int n = mouseEvent.getX();
                int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
                PMVMatrix pMVMatrix = new PMVMatrix();
                Vec3f vec3f = new Vec3f();
                Scene.this.winToShapeCoord(shape, n, n2, pMVMatrix, vec3f, () -> shape.dispatchGestureEvent(gestureEvent, n, n2, pMVMatrix, Scene.this.renderer.getViewport(), vec3f));
            }
        }
    }

    private class SBCMouseListener
    implements MouseListener {
        int lx = -1;
        int ly = -1;
        int lId = -1;

        private SBCMouseListener() {
        }

        void clear() {
            this.lx = -1;
            this.ly = -1;
            this.lId = -1;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (-1 == this.lId || mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                this.lId = mouseEvent.getPointerId(0);
            }
            int n = mouseEvent.getX();
            int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
            Scene.this.dispatchMouseEvent(mouseEvent, n, n2);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
            Scene.this.dispatchMouseEvent(mouseEvent, n, n2);
            if (1 == mouseEvent.getPointerCount()) {
                Scene.this.releaseActiveShape();
                this.clear();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = Scene.this.getHeight() - mouseEvent.getY() - 1;
            Scene.this.dispatchMouseEventPickShape(mouseEvent, n, n2);
            Scene.this.releaseActiveShape();
            this.clear();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (null != Scene.this.activeShape && !Scene.this.pinchToZoomGesture.isWithinGesture() && mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                int n = this.lx;
                int n2 = Scene.this.getHeight() - this.ly - 1;
                Scene.this.dispatchMouseEventForShape(Scene.this.activeShape, mouseEvent, n, n2);
            }
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
            int n = this.lx;
            int n2 = Scene.this.getHeight() - this.ly - 1;
            Scene.this.dispatchMouseEvent(mouseEvent, n, n2);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (-1 == this.lId || mouseEvent.getPointerId(0) == this.lId) {
                this.lx = mouseEvent.getX();
                this.ly = mouseEvent.getY();
                this.lId = mouseEvent.getPointerId(0);
            }
            int n = this.lx;
            int n2 = Scene.this.getHeight() - this.ly - 1;
            Scene.this.dispatchMouseEventPickShape(mouseEvent, n, n2);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Scene.this.releaseActiveShape();
            this.clear();
        }
    }
}

