// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GTKMM_HEADERBAR_H
#define _GTKMM_HEADERBAR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/widget.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkHeaderBar = struct _GtkHeaderBar;
using GtkHeaderBarClass = struct _GtkHeaderBarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API HeaderBar_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A box with a centered child.
 *
 * Gtk::HeaderBar is similar to a horizontal Gtk::Box, it allows
 * to place children at the start or the end. In addition,
 * it allows a title to be displayed. The title will be
 * centered with respect to the width of the box, even if the children
 * at either side take up different amounts of space.
 *
 * @ingroup Containers
 * @newin{3,10}
 */

class GTKMM_API HeaderBar
  : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef HeaderBar CppObjectType;
  typedef HeaderBar_Class CppClassType;
  typedef GtkHeaderBar BaseObjectType;
  typedef GtkHeaderBarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  HeaderBar(HeaderBar&& src) noexcept;
  HeaderBar& operator=(HeaderBar&& src) noexcept;

  // noncopyable
  HeaderBar(const HeaderBar&) = delete;
  HeaderBar& operator=(const HeaderBar&) = delete;

  ~HeaderBar() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend GTKMM_API class HeaderBar_Class;
  static CppClassType headerbar_class_;

protected:
  explicit HeaderBar(const Glib::ConstructParams& construct_params);
  explicit HeaderBar(GtkHeaderBar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkHeaderBar*       gobj()       { return reinterpret_cast<GtkHeaderBar*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkHeaderBar* gobj() const { return reinterpret_cast<GtkHeaderBar*>(gobject_); }

private:

public:

  /** Create a new HeaderBar widget.
   */
  HeaderBar();

  
  /** Sets the title for the header bar.
   * 
   * When set to <tt>nullptr</tt>, the headerbar will display the title of
   * the window it is contained in.
   * 
   * The title should help a user identify the current view.
   * To achieve the same style as the builtin title, use the
   * “title” style class.
   * 
   * You should set the title widget to <tt>nullptr</tt>, for the window
   * title label to be visible again.
   * 
   * @param title_widget A widget to use for a title.
   */
  void set_title_widget(Gtk::Widget& title_widget);
  
  /** Retrieves the title widget of the header bar.
   * 
   * See set_title_widget().
   * 
   * @return The title widget.
   */
  Widget* get_title_widget();
  
  /** Retrieves the title widget of the header bar.
   * 
   * See set_title_widget().
   * 
   * @return The title widget.
   */
  const Widget* get_title_widget() const;

  
  /** Adds a child to the header bar, packed with reference to the start.
   * 
   * @param child The widget to be added to @a bar.
   */
  void pack_start(Gtk::Widget& child);
  
  /** Adds a child to the header bar, packed with reference to the end.
   * 
   * @param child The widget to be added to @a bar.
   */
  void pack_end(Gtk::Widget& child);
  
  /** Removes a child from the header bar.
   * 
   * The child must have been added with
   * pack_start(),
   * pack_end() or
   * set_title_widget().
   * 
   * @param child The child to remove.
   */
  void remove(Gtk::Widget& child);

  
  /** Sets whether this header bar shows the standard window
   * title buttons.
   * 
   * @param setting True to show standard title buttons.
   */
  void set_show_title_buttons(bool setting =  true);
  
  /** Returns whether this header bar shows the standard window
   * title buttons.
   * 
   * @return True if title buttons are shown.
   */
  bool get_show_title_buttons() const;

  
  /** Sets the decoration layout for this header bar.
   * 
   * This property overrides the
   * Gtk::Settings::property_gtk_decoration_layout() setting.
   * 
   * There can be valid reasons for overriding the setting, such
   * as a header bar design that does not allow for buttons to take
   * room on the right, or only offers room for a single close button.
   * Split header bars are another example for overriding the setting.
   * 
   * The format of the string is button names, separated by commas.
   * A colon separates the buttons that should appear on the left
   * from those on the right. Recognized button names are minimize,
   * maximize, close and icon (the window icon).
   * 
   * For example, “icon:minimize,maximize,close” specifies an icon
   * on the left, and minimize, maximize and close buttons on the right.
   * 
   * @param layout A decoration layout.
   */
  void set_decoration_layout(const Glib::ustring& layout);

  /** Unset the decoration layout.
   * See set_decoration_layout().
   */
  void unset_decoration_layout();

  
  /** Gets the decoration layout of the header bar.
   * 
   * @return The decoration layout.
   */
  Glib::ustring get_decoration_layout() const;

  
  /** Returns whether this header bar shows platform
   * native window controls.
   * 
   * @newin{4,18}
   * 
   * @return True if native window controls are shown.
   */
  bool get_use_native_controls() const;
  
  /** Sets whether this header bar shows native window controls.
   * 
   * This option shows the "stoplight" buttons on macOS.
   * For Linux, this option has no effect.
   * 
   * See also [Using GTK on Apple macOS](osx.html?native-window-controls).
   * 
   * @newin{4,18}
   * 
   * @param setting True to show native window controls.
   */
  void set_use_native_controls(bool setting =  true);

  /** The title widget to display.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gtk::Widget* > property_title_widget() ;

/** The title widget to display.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::Widget* > property_title_widget() const;

  /** Whether to show title buttons like close, minimize, maximize.
   * 
   * Which buttons are actually shown and where is determined
   * by the property_decoration_layout() property,
   * and by the state of the window (e.g. a close button will not
   * be shown if the window can't be closed).
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_title_buttons() ;

/** Whether to show title buttons like close, minimize, maximize.
   * 
   * Which buttons are actually shown and where is determined
   * by the property_decoration_layout() property,
   * and by the state of the window (e.g. a close button will not
   * be shown if the window can't be closed).
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_title_buttons() const;

  /** The decoration layout for buttons.
   * 
   * If this property is not set, the
   * Gtk::Settings::property_gtk_decoration_layout() setting is used.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_decoration_layout() ;

/** The decoration layout for buttons.
   * 
   * If this property is not set, the
   * Gtk::Settings::property_gtk_decoration_layout() setting is used.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_decoration_layout() const;

  /** Whether to show platform native close/minimize/maximize buttons.
   * 
   * For macOS, the property_decoration_layout() property
   * can be used to enable/disable controls.
   * 
   * On Linux, this option has no effect.
   * 
   * See also [Using GTK on Apple macOS](osx.html?native-window-controls).
   * 
   * @newin{4,18}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_native_controls() ;

/** Whether to show platform native close/minimize/maximize buttons.
   * 
   * For macOS, the property_decoration_layout() property
   * can be used to enable/disable controls.
   * 
   * On Linux, this option has no effect.
   * 
   * See also [Using GTK on Apple macOS](osx.html?native-window-controls).
   * 
   * @newin{4,18}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_native_controls() const;


  // Gtk::HeaderBar has no signals nor vfuncs as of 3.12.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::HeaderBar
   */
  GTKMM_API
  Gtk::HeaderBar* wrap(GtkHeaderBar* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_HEADERBAR_H */

