#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42.2
visibility:           public
id:                   hledger-web-1.42.2-Gy9CLYFFmHlEromJefkDfT
key:                  hledger-web-1.42.2-Gy9CLYFFmHlEromJefkDfT
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  42bbb4c9cb6fe1789b6efae90dbb898a
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42.2-Gy9CLYFFmHlEromJefkDfT
depends:
    Decimal-0.5.2-8yGkpO2k9uU74qW1Gscpn9
    aeson-2.1.2.1-DAjCoZEGWBTDXHPn96Kb1j base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz
    base64-1.0-Eo2QT8WPvS4EISC7NGB0MV
    blaze-html-0.9.2.0-BNiEFLNNUNIEHlooTHUqgE
    blaze-markup-0.8.3.0-9A4diNUSs8a27GmMCxTlZs bytestring-0.11.5.3
    case-insensitive-1.2.1.0-Fpgl4YyjrVl4Gttb0PploH
    clientsession-0.9.3.0-6hkuooKw5tZ9Swglz69oxh
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-LOP5sjciwZZGtwvmGKv7ZW
    conduit-extra-1.3.8-1JMiFOCwvslD8QGjqNo8o8 containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-JyTxBhiayTkLmgcKeg6bhV filepath-1.4.2.2
    githash-0.1.6.3-K72A3YGzbqu3kN19ch9IsE
    hjsmin-0.2.1-IqGjcq34EZo3nJSlIVfLhF
    hledger-1.42.2-LXPWuC0NNauBHEWJJZulIs
    hledger-lib-1.42.2-FDVdiuuMoe0DloFQjMwiX4
    hspec-2.11.3-3qKR9XcZpQB1G3Vj0rUm9Y
    http-client-0.7.19-EHZ8YuN7FJhcdM1bWuZGu
    http-conduit-2.3.9.1-9Ct6jgxY5X12F1xXSm7cXD
    http-types-0.12.4-8HR0lcMpUwL4edtlDqx8uG
    megaparsec-9.7.0-8uORpW7l6sW5AZf9TKEbic mtl-2.2.2
    network-3.1.4.0-4UbSgXPdAp7DQ7Pftr1aPB
    safe-0.3.21-159SecEsuJT5xXa0fzfSU2
    shakespeare-2.1.4-6vSci7QTAiKLm6E4I86txo template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-9t2FupNpdHvF9CotjWq7e6
    unordered-containers-0.2.20-C5ENqrDu1w64CLikkGEoYH
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-54grchYoKyyD66je19YTSn
    wai-cors-0.2.7-2SU4PaVUZN0Jz8TLNIBqee
    wai-extra-3.1.18-A3StP8Fsv6ZKkPTrNgjMD3
    wai-handler-launch-3.0.3.1-H5OvuQfyvWk9b6f8DJ8wos
    warp-3.3.31-KE5H9mDCEjAKQ3W6oJRFhX
    yaml-0.11.11.2-G90lzws7ieR6hOxChJvZJC
    yesod-1.6.2.1-AxUnEUX0FDW1xQjECqS5Yd
    yesod-core-1.6.27.1-BS85scoE9JKEcJANdJiewT
    yesod-form-1.7.9-IUGQOkqBJFeBbOkozaf1bu
    yesod-static-1.6.1.0-Ej1LvTN3DwBBDpZxJMsAy0
    yesod-test-1.6.23-LFoyzYbGNAwFdY4X4mhhzs

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

