/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Casts input pixels to output pixel type and clamps the output pixel
values to a specified range.


Default range corresponds to the range supported by the pixel type of
the output image.

This filter is templated over the input image type and the output
image type.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 UnaryFunctorImageFilter

 CastImageFilter

 itk::simple::Clamp for the procedural interface

 itk::ClampImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkClampImageFilter.h
*/
public class ClampImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ClampImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ClampImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ClampImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ClampImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ClampImageFilter::~ClampImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ClampImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ClampImageFilter::ClampImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ClampImageFilter() {
    this(SimpleITKJNI.new_ClampImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ClampImageFilter::SetOutputPixelType(PixelIDValueEnum OutputPixelType)
*/
public  void setOutputPixelType(PixelIDValueEnum OutputPixelType) {
    SimpleITKJNI.ClampImageFilter_setOutputPixelType(swigCPtr, this, OutputPixelType.swigValue());
  }

  /**
PixelIDValueEnum itk::simple::ClampImageFilter::GetOutputPixelType() const
*/
public  PixelIDValueEnum getOutputPixelType() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.ClampImageFilter_getOutputPixelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ClampImageFilter::SetLowerBound(double LowerBound)
*/
public  void setLowerBound(double LowerBound) {
    SimpleITKJNI.ClampImageFilter_setLowerBound(swigCPtr, this, LowerBound);
  }

  /**
double itk::simple::ClampImageFilter::GetLowerBound() const
*/
public  double getLowerBound() {
    return SimpleITKJNI.ClampImageFilter_getLowerBound(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ClampImageFilter::SetUpperBound(double UpperBound)
*/
public  void setUpperBound(double UpperBound) {
    SimpleITKJNI.ClampImageFilter_setUpperBound(swigCPtr, this, UpperBound);
  }

  /**
double itk::simple::ClampImageFilter::GetUpperBound() const
*/
public  double getUpperBound() {
    return SimpleITKJNI.ClampImageFilter_getUpperBound(swigCPtr, this);
  }

  /**
std::string itk::simple::ClampImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ClampImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ClampImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ClampImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ClampImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ClampImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
