/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Generate an n-dimensional image of a Gabor filter.


GaborImageSource generates an image of either the real (i.e. symmetric) or complex
(i.e. antisymmetric) part of the Gabor filter with the orientation
directed along the x-axis. The GaborKernelFunction is used to evaluate the contribution along the x-axis whereas a non-
normalized 1-D Gaussian envelope provides the contribution in each of
the remaining N dimensions. Orientation can be manipulated via the Transform classes of the toolkit.

The output image may be of any dimension.

This implementation was contributed as a paper to the Insight Journal https://doi.org/10.54294/dhogdz
See:
 itk::simple::GaborSource for the procedural interface

 itk::GaborImageSource for the Doxygen on the original ITK class.


C++ includes: sitkGaborImageSource.h
*/
public class GaborImageSource extends ImageFilter {
  private transient long swigCPtr;

  protected GaborImageSource(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GaborImageSource_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GaborImageSource obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GaborImageSource obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GaborImageSource::~GaborImageSource()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GaborImageSource(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GaborImageSource::GaborImageSource()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GaborImageSource() {
    this(SimpleITKJNI.new_GaborImageSource(), true);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetOutputPixelType(PixelIDValueEnum OutputPixelType)
*/
public  void setOutputPixelType(PixelIDValueEnum OutputPixelType) {
    SimpleITKJNI.GaborImageSource_setOutputPixelType(swigCPtr, this, OutputPixelType.swigValue());
  }

  /**
PixelIDValueEnum itk::simple::GaborImageSource::GetOutputPixelType() const
*/
public  PixelIDValueEnum getOutputPixelType() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.GaborImageSource_getOutputPixelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetSize(std::vector&lt; unsigned int &gt; Size)
*/
public  void setSize(VectorUInt32 Size) {
    SimpleITKJNI.GaborImageSource_setSize(swigCPtr, this, VectorUInt32.getCPtr(Size), Size);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::GaborImageSource::GetSize() const
*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.GaborImageSource_getSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetSigma(std::vector&lt; double &gt; Sigma)

Set/Get the standard deviation in each direction.

*/
public  void setSigma(VectorDouble Sigma) {
    SimpleITKJNI.GaborImageSource_setSigma__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Sigma), Sigma);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetSigma(std::vector&lt; double &gt; Sigma)

Set/Get the standard deviation in each direction.

*/
public  void setSigma(double value) {
    SimpleITKJNI.GaborImageSource_setSigma__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaborImageSource::GetSigma() const

Set/Get the standard deviation in each direction.

*/
public  VectorDouble getSigma() {
    return new VectorDouble(SimpleITKJNI.GaborImageSource_getSigma(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetMean(std::vector&lt; double &gt; Mean)

Set/Get the mean in each direction.

*/
public  void setMean(VectorDouble Mean) {
    SimpleITKJNI.GaborImageSource_setMean__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Mean), Mean);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetMean(std::vector&lt; double &gt; Mean)

Set/Get the mean in each direction.

*/
public  void setMean(double value) {
    SimpleITKJNI.GaborImageSource_setMean__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaborImageSource::GetMean() const

Set/Get the mean in each direction.

*/
public  VectorDouble getMean() {
    return new VectorDouble(SimpleITKJNI.GaborImageSource_getMean(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetFrequency(double Frequency)

Set/Get the modulation frequency of the sine or cosine component.

*/
public  void setFrequency(double Frequency) {
    SimpleITKJNI.GaborImageSource_setFrequency(swigCPtr, this, Frequency);
  }

  /**
double itk::simple::GaborImageSource::GetFrequency() const

Set/Get the modulation frequency of the sine or cosine component.

*/
public  double getFrequency() {
    return SimpleITKJNI.GaborImageSource_getFrequency(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetOrigin(std::vector&lt; double &gt; Origin)
*/
public  void setOrigin(VectorDouble Origin) {
    SimpleITKJNI.GaborImageSource_setOrigin(swigCPtr, this, VectorDouble.getCPtr(Origin), Origin);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaborImageSource::GetOrigin() const
*/
public  VectorDouble getOrigin() {
    return new VectorDouble(SimpleITKJNI.GaborImageSource_getOrigin(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetSpacing(std::vector&lt; double &gt; Spacing)
*/
public  void setSpacing(VectorDouble Spacing) {
    SimpleITKJNI.GaborImageSource_setSpacing(swigCPtr, this, VectorDouble.getCPtr(Spacing), Spacing);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaborImageSource::GetSpacing() const
*/
public  VectorDouble getSpacing() {
    return new VectorDouble(SimpleITKJNI.GaborImageSource_getSpacing(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GaborImageSource::SetDirection(std::vector&lt; double &gt; Direction)
*/
public  void setDirection(VectorDouble Direction) {
    SimpleITKJNI.GaborImageSource_setDirection(swigCPtr, this, VectorDouble.getCPtr(Direction), Direction);
  }

  /**
std::vector&lt;double&gt; itk::simple::GaborImageSource::GetDirection() const
*/
public  VectorDouble getDirection() {
    return new VectorDouble(SimpleITKJNI.GaborImageSource_getDirection(swigCPtr, this), true);
  }

  /**
std::string itk::simple::GaborImageSource::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GaborImageSource_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GaborImageSource::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GaborImageSource_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GaborImageSource::Execute()

Execute the filter on the input image

*/
public  Image execute() {
    return new Image(SimpleITKJNI.GaborImageSource_execute(swigCPtr, this), true);
  }

}
