/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import mediathek.config.Daten;
import mediathek.gui.messages.UpdateStatusBarLeftDisplayEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.jetbrains.annotations.NotNull;

public class FilmSizeInfoLabel
extends JLabel
implements ActionListener {
    private int oldGesamt;
    private int oldRowCount;
    private final MediathekGui mediathekGui;
    private final Timer timer;

    public FilmSizeInfoLabel(@NotNull MediathekGui mediathekGui) {
        this.mediathekGui = mediathekGui;
        this.timer = new Timer(1000, this);
        this.timer.setRepeats(true);
        this.timer.start();
        MessageBus.getMessageBus().subscribe(this);
    }

    @Handler
    private void handleLeftDisplayUpdate(UpdateStatusBarLeftDisplayEvent e) {
        SwingUtilities.invokeLater(this::updateValues);
    }

    private void updateValues() {
        Object textLinks;
        int gesamt = Daten.getInstance().getListeFilme().size();
        int rowCount = this.mediathekGui.tabFilme.getTableRowCount();
        if (gesamt == this.oldGesamt && rowCount == this.oldRowCount) {
            return;
        }
        if (gesamt == rowCount) {
            textLinks = this.createFilmLabel(rowCount);
        } else {
            textLinks = this.createFilmLabel(rowCount);
            textLinks = (String)textLinks + " (Insgesamt: " + gesamt + ")";
        }
        this.setText((String)textLinks);
        this.oldGesamt = gesamt;
        this.oldRowCount = rowCount;
    }

    private String createFilmLabel(int rowCount) {
        Object textLinks = rowCount == 1 ? "1 Film" : rowCount + " Filme";
        return textLinks;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateValues();
    }
}

