/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class Within
extends IntervalFunction {
    private final int positions;
    private final IntervalFunction source;
    private final IntervalFunction reference;

    public Within(IntervalFunction source2, int positions, IntervalFunction reference) {
        this.positions = positions;
        this.source = Objects.requireNonNull(source2);
        this.reference = Objects.requireNonNull(reference);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.within(this.source.toIntervalSource(field, analyzer), this.positions, this.reference.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:within(%s %d %s)", this.source, this.positions, this.reference);
    }
}

