# frozen_string_literal: true

=begin
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/inspect_visitor.rb.erb
if you are looking to modify the template
=end

module Prism
  # This visitor is responsible for composing the strings that get returned by
  # the various #inspect methods defined on each of the nodes.
  class InspectVisitor < Visitor
    # Most of the time, we can simply pass down the indent to the next node.
    # However, when we are inside a list we want some extra special formatting
    # when we hit an element in that list. In this case, we have a special
    # command that replaces the subsequent indent with the given value.
    class Replace # :nodoc:
      attr_reader :value

      def initialize(value)
        @value = value
      end
    end

    private_constant :Replace

    # The current prefix string.
    attr_reader :indent

    # The list of commands that we need to execute in order to compose the
    # final string.
    attr_reader :commands

    # Initializes a new instance of the InspectVisitor.
    def initialize(indent = +"")
      @indent = indent
      @commands = []
    end

    # Compose an inspect string for the given node.
    def self.compose(node)
      visitor = new
      node.accept(visitor)
      visitor.compose
    end

    # Compose the final string.
    def compose
      buffer = +""
      replace = nil

      until commands.empty?
        # @type var command: String | node | Replace
        # @type var indent: String
        command, indent = *commands.shift

        case command
        when String
          buffer << (replace || indent)
          buffer << command
          replace = nil
        when Node
          visitor = InspectVisitor.new(indent)
          command.accept(visitor)
          @commands = [*visitor.commands, *@commands]
        when Replace
          replace = command.value
        else
          raise "Unknown command: #{command.inspect}"
        end
      end

      buffer
    end

    # Inspect a AliasGlobalVariableNode node.
    def visit_alias_global_variable_node(node)
      commands << [inspect_node("AliasGlobalVariableNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── new_name:\n", indent]
      commands << [node.new_name, "#{indent}│   "]
      commands << ["├── old_name:\n", indent]
      commands << [node.old_name, "#{indent}│   "]
      commands << ["└── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
    end

    # Inspect a AliasMethodNode node.
    def visit_alias_method_node(node)
      commands << [inspect_node("AliasMethodNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── new_name:\n", indent]
      commands << [node.new_name, "#{indent}│   "]
      commands << ["├── old_name:\n", indent]
      commands << [node.old_name, "#{indent}│   "]
      commands << ["└── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
    end

    # Inspect a AlternationPatternNode node.
    def visit_alternation_pattern_node(node)
      commands << [inspect_node("AlternationPatternNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── left:\n", indent]
      commands << [node.left, "#{indent}│   "]
      commands << ["├── right:\n", indent]
      commands << [node.right, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a AndNode node.
    def visit_and_node(node)
      commands << [inspect_node("AndNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── left:\n", indent]
      commands << [node.left, "#{indent}│   "]
      commands << ["├── right:\n", indent]
      commands << [node.right, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a ArgumentsNode node.
    def visit_arguments_node(node)
      commands << [inspect_node("ArgumentsNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("contains_forwarding" if node.contains_forwarding?), ("contains_keywords" if node.contains_keywords?), ("contains_keyword_splat" if node.contains_keyword_splat?), ("contains_splat" if node.contains_splat?), ("contains_multiple_splats" if node.contains_multiple_splats?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── arguments: (length: #{(arguments = node.arguments).length})\n", indent]
      if arguments.any?
        arguments[0...-1].each do |child|
          commands << [Replace.new("#{indent}    ├── "), indent]
          commands << [child, "#{indent}    │   "]
        end
        commands << [Replace.new("#{indent}    └── "), indent]
        commands << [arguments[-1], "#{indent}        "]
      end
    end

    # Inspect a ArrayNode node.
    def visit_array_node(node)
      commands << [inspect_node("ArrayNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("contains_splat" if node.contains_splat?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── elements: (length: #{(elements = node.elements).length})\n", indent]
      if elements.any?
        elements[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [elements[-1], "#{indent}│       "]
      end
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a ArrayPatternNode node.
    def visit_array_pattern_node(node)
      commands << [inspect_node("ArrayPatternNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (constant = node.constant).nil?
        commands << ["├── constant: ∅\n", indent]
      else
        commands << ["├── constant:\n", indent]
        commands << [constant, "#{indent}│   "]
      end
      commands << ["├── requireds: (length: #{(requireds = node.requireds).length})\n", indent]
      if requireds.any?
        requireds[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [requireds[-1], "#{indent}│       "]
      end
      if (rest = node.rest).nil?
        commands << ["├── rest: ∅\n", indent]
      else
        commands << ["├── rest:\n", indent]
        commands << [rest, "#{indent}│   "]
      end
      commands << ["├── posts: (length: #{(posts = node.posts).length})\n", indent]
      if posts.any?
        posts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [posts[-1], "#{indent}│       "]
      end
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a AssocNode node.
    def visit_assoc_node(node)
      commands << [inspect_node("AssocNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── key:\n", indent]
      commands << [node.key, "#{indent}│   "]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a AssocSplatNode node.
    def visit_assoc_splat_node(node)
      commands << [inspect_node("AssocSplatNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (value = node.value).nil?
        commands << ["├── value: ∅\n", indent]
      else
        commands << ["├── value:\n", indent]
        commands << [value, "#{indent}│   "]
      end
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a BackReferenceReadNode node.
    def visit_back_reference_read_node(node)
      commands << [inspect_node("BackReferenceReadNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a BeginNode node.
    def visit_begin_node(node)
      commands << [inspect_node("BeginNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── begin_keyword_loc: #{inspect_location(node.begin_keyword_loc)}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      if (rescue_clause = node.rescue_clause).nil?
        commands << ["├── rescue_clause: ∅\n", indent]
      else
        commands << ["├── rescue_clause:\n", indent]
        commands << [rescue_clause, "#{indent}│   "]
      end
      if (else_clause = node.else_clause).nil?
        commands << ["├── else_clause: ∅\n", indent]
      else
        commands << ["├── else_clause:\n", indent]
        commands << [else_clause, "#{indent}│   "]
      end
      if (ensure_clause = node.ensure_clause).nil?
        commands << ["├── ensure_clause: ∅\n", indent]
      else
        commands << ["├── ensure_clause:\n", indent]
        commands << [ensure_clause, "#{indent}│   "]
      end
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a BlockArgumentNode node.
    def visit_block_argument_node(node)
      commands << [inspect_node("BlockArgumentNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (expression = node.expression).nil?
        commands << ["├── expression: ∅\n", indent]
      else
        commands << ["├── expression:\n", indent]
        commands << [expression, "#{indent}│   "]
      end
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a BlockLocalVariableNode node.
    def visit_block_local_variable_node(node)
      commands << [inspect_node("BlockLocalVariableNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("repeated_parameter" if node.repeated_parameter?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a BlockNode node.
    def visit_block_node(node)
      commands << [inspect_node("BlockNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── locals: #{node.locals.inspect}\n", indent]
      if (parameters = node.parameters).nil?
        commands << ["├── parameters: ∅\n", indent]
      else
        commands << ["├── parameters:\n", indent]
        commands << [parameters, "#{indent}│   "]
      end
      if (body = node.body).nil?
        commands << ["├── body: ∅\n", indent]
      else
        commands << ["├── body:\n", indent]
        commands << [body, "#{indent}│   "]
      end
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a BlockParameterNode node.
    def visit_block_parameter_node(node)
      commands << [inspect_node("BlockParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("repeated_parameter" if node.repeated_parameter?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (name = node.name).nil?
        commands << ["├── name: ∅\n", indent]
      else
        commands << ["├── name: #{name.inspect}\n", indent]
      end
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a BlockParametersNode node.
    def visit_block_parameters_node(node)
      commands << [inspect_node("BlockParametersNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (parameters = node.parameters).nil?
        commands << ["├── parameters: ∅\n", indent]
      else
        commands << ["├── parameters:\n", indent]
        commands << [parameters, "#{indent}│   "]
      end
      commands << ["├── locals: (length: #{(locals = node.locals).length})\n", indent]
      if locals.any?
        locals[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [locals[-1], "#{indent}│       "]
      end
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a BreakNode node.
    def visit_break_node(node)
      commands << [inspect_node("BreakNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["└── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
    end

    # Inspect a CallAndWriteNode node.
    def visit_call_and_write_node(node)
      commands << [inspect_node("CallAndWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (receiver = node.receiver).nil?
        commands << ["├── receiver: ∅\n", indent]
      else
        commands << ["├── receiver:\n", indent]
        commands << [receiver, "#{indent}│   "]
      end
      commands << ["├── call_operator_loc: #{inspect_location(node.call_operator_loc)}\n", indent]
      commands << ["├── message_loc: #{inspect_location(node.message_loc)}\n", indent]
      commands << ["├── read_name: #{node.read_name.inspect}\n", indent]
      commands << ["├── write_name: #{node.write_name.inspect}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a CallNode node.
    def visit_call_node(node)
      commands << [inspect_node("CallNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (receiver = node.receiver).nil?
        commands << ["├── receiver: ∅\n", indent]
      else
        commands << ["├── receiver:\n", indent]
        commands << [receiver, "#{indent}│   "]
      end
      commands << ["├── call_operator_loc: #{inspect_location(node.call_operator_loc)}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── message_loc: #{inspect_location(node.message_loc)}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      if (block = node.block).nil?
        commands << ["└── block: ∅\n", indent]
      else
        commands << ["└── block:\n", indent]
        commands << [block, "#{indent}    "]
      end
    end

    # Inspect a CallOperatorWriteNode node.
    def visit_call_operator_write_node(node)
      commands << [inspect_node("CallOperatorWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (receiver = node.receiver).nil?
        commands << ["├── receiver: ∅\n", indent]
      else
        commands << ["├── receiver:\n", indent]
        commands << [receiver, "#{indent}│   "]
      end
      commands << ["├── call_operator_loc: #{inspect_location(node.call_operator_loc)}\n", indent]
      commands << ["├── message_loc: #{inspect_location(node.message_loc)}\n", indent]
      commands << ["├── read_name: #{node.read_name.inspect}\n", indent]
      commands << ["├── write_name: #{node.write_name.inspect}\n", indent]
      commands << ["├── binary_operator: #{node.binary_operator.inspect}\n", indent]
      commands << ["├── binary_operator_loc: #{inspect_location(node.binary_operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a CallOrWriteNode node.
    def visit_call_or_write_node(node)
      commands << [inspect_node("CallOrWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (receiver = node.receiver).nil?
        commands << ["├── receiver: ∅\n", indent]
      else
        commands << ["├── receiver:\n", indent]
        commands << [receiver, "#{indent}│   "]
      end
      commands << ["├── call_operator_loc: #{inspect_location(node.call_operator_loc)}\n", indent]
      commands << ["├── message_loc: #{inspect_location(node.message_loc)}\n", indent]
      commands << ["├── read_name: #{node.read_name.inspect}\n", indent]
      commands << ["├── write_name: #{node.write_name.inspect}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a CallTargetNode node.
    def visit_call_target_node(node)
      commands << [inspect_node("CallTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── receiver:\n", indent]
      commands << [node.receiver, "#{indent}│   "]
      commands << ["├── call_operator_loc: #{inspect_location(node.call_operator_loc)}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["└── message_loc: #{inspect_location(node.message_loc)}\n", indent]
    end

    # Inspect a CapturePatternNode node.
    def visit_capture_pattern_node(node)
      commands << [inspect_node("CapturePatternNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["├── target:\n", indent]
      commands << [node.target, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a CaseMatchNode node.
    def visit_case_match_node(node)
      commands << [inspect_node("CaseMatchNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (predicate = node.predicate).nil?
        commands << ["├── predicate: ∅\n", indent]
      else
        commands << ["├── predicate:\n", indent]
        commands << [predicate, "#{indent}│   "]
      end
      commands << ["├── conditions: (length: #{(conditions = node.conditions).length})\n", indent]
      if conditions.any?
        conditions[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [conditions[-1], "#{indent}│       "]
      end
      if (else_clause = node.else_clause).nil?
        commands << ["├── else_clause: ∅\n", indent]
      else
        commands << ["├── else_clause:\n", indent]
        commands << [else_clause, "#{indent}│   "]
      end
      commands << ["├── case_keyword_loc: #{inspect_location(node.case_keyword_loc)}\n", indent]
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a CaseNode node.
    def visit_case_node(node)
      commands << [inspect_node("CaseNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (predicate = node.predicate).nil?
        commands << ["├── predicate: ∅\n", indent]
      else
        commands << ["├── predicate:\n", indent]
        commands << [predicate, "#{indent}│   "]
      end
      commands << ["├── conditions: (length: #{(conditions = node.conditions).length})\n", indent]
      if conditions.any?
        conditions[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [conditions[-1], "#{indent}│       "]
      end
      if (else_clause = node.else_clause).nil?
        commands << ["├── else_clause: ∅\n", indent]
      else
        commands << ["├── else_clause:\n", indent]
        commands << [else_clause, "#{indent}│   "]
      end
      commands << ["├── case_keyword_loc: #{inspect_location(node.case_keyword_loc)}\n", indent]
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a ClassNode node.
    def visit_class_node(node)
      commands << [inspect_node("ClassNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── locals: #{node.locals.inspect}\n", indent]
      commands << ["├── class_keyword_loc: #{inspect_location(node.class_keyword_loc)}\n", indent]
      commands << ["├── constant_path:\n", indent]
      commands << [node.constant_path, "#{indent}│   "]
      commands << ["├── inheritance_operator_loc: #{inspect_location(node.inheritance_operator_loc)}\n", indent]
      if (superclass = node.superclass).nil?
        commands << ["├── superclass: ∅\n", indent]
      else
        commands << ["├── superclass:\n", indent]
        commands << [superclass, "#{indent}│   "]
      end
      if (body = node.body).nil?
        commands << ["├── body: ∅\n", indent]
      else
        commands << ["├── body:\n", indent]
        commands << [body, "#{indent}│   "]
      end
      commands << ["├── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a ClassVariableAndWriteNode node.
    def visit_class_variable_and_write_node(node)
      commands << [inspect_node("ClassVariableAndWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a ClassVariableOperatorWriteNode node.
    def visit_class_variable_operator_write_node(node)
      commands << [inspect_node("ClassVariableOperatorWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── binary_operator_loc: #{inspect_location(node.binary_operator_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── binary_operator: #{node.binary_operator.inspect}\n", indent]
    end

    # Inspect a ClassVariableOrWriteNode node.
    def visit_class_variable_or_write_node(node)
      commands << [inspect_node("ClassVariableOrWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a ClassVariableReadNode node.
    def visit_class_variable_read_node(node)
      commands << [inspect_node("ClassVariableReadNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a ClassVariableTargetNode node.
    def visit_class_variable_target_node(node)
      commands << [inspect_node("ClassVariableTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a ClassVariableWriteNode node.
    def visit_class_variable_write_node(node)
      commands << [inspect_node("ClassVariableWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a ConstantAndWriteNode node.
    def visit_constant_and_write_node(node)
      commands << [inspect_node("ConstantAndWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a ConstantOperatorWriteNode node.
    def visit_constant_operator_write_node(node)
      commands << [inspect_node("ConstantOperatorWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── binary_operator_loc: #{inspect_location(node.binary_operator_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── binary_operator: #{node.binary_operator.inspect}\n", indent]
    end

    # Inspect a ConstantOrWriteNode node.
    def visit_constant_or_write_node(node)
      commands << [inspect_node("ConstantOrWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a ConstantPathAndWriteNode node.
    def visit_constant_path_and_write_node(node)
      commands << [inspect_node("ConstantPathAndWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── target:\n", indent]
      commands << [node.target, "#{indent}│   "]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a ConstantPathNode node.
    def visit_constant_path_node(node)
      commands << [inspect_node("ConstantPathNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (parent = node.parent).nil?
        commands << ["├── parent: ∅\n", indent]
      else
        commands << ["├── parent:\n", indent]
        commands << [parent, "#{indent}│   "]
      end
      if (name = node.name).nil?
        commands << ["├── name: ∅\n", indent]
      else
        commands << ["├── name: #{name.inspect}\n", indent]
      end
      commands << ["├── delimiter_loc: #{inspect_location(node.delimiter_loc)}\n", indent]
      commands << ["└── name_loc: #{inspect_location(node.name_loc)}\n", indent]
    end

    # Inspect a ConstantPathOperatorWriteNode node.
    def visit_constant_path_operator_write_node(node)
      commands << [inspect_node("ConstantPathOperatorWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── target:\n", indent]
      commands << [node.target, "#{indent}│   "]
      commands << ["├── binary_operator_loc: #{inspect_location(node.binary_operator_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── binary_operator: #{node.binary_operator.inspect}\n", indent]
    end

    # Inspect a ConstantPathOrWriteNode node.
    def visit_constant_path_or_write_node(node)
      commands << [inspect_node("ConstantPathOrWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── target:\n", indent]
      commands << [node.target, "#{indent}│   "]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a ConstantPathTargetNode node.
    def visit_constant_path_target_node(node)
      commands << [inspect_node("ConstantPathTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (parent = node.parent).nil?
        commands << ["├── parent: ∅\n", indent]
      else
        commands << ["├── parent:\n", indent]
        commands << [parent, "#{indent}│   "]
      end
      if (name = node.name).nil?
        commands << ["├── name: ∅\n", indent]
      else
        commands << ["├── name: #{name.inspect}\n", indent]
      end
      commands << ["├── delimiter_loc: #{inspect_location(node.delimiter_loc)}\n", indent]
      commands << ["└── name_loc: #{inspect_location(node.name_loc)}\n", indent]
    end

    # Inspect a ConstantPathWriteNode node.
    def visit_constant_path_write_node(node)
      commands << [inspect_node("ConstantPathWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── target:\n", indent]
      commands << [node.target, "#{indent}│   "]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a ConstantReadNode node.
    def visit_constant_read_node(node)
      commands << [inspect_node("ConstantReadNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a ConstantTargetNode node.
    def visit_constant_target_node(node)
      commands << [inspect_node("ConstantTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a ConstantWriteNode node.
    def visit_constant_write_node(node)
      commands << [inspect_node("ConstantWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a DefNode node.
    def visit_def_node(node)
      commands << [inspect_node("DefNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      if (receiver = node.receiver).nil?
        commands << ["├── receiver: ∅\n", indent]
      else
        commands << ["├── receiver:\n", indent]
        commands << [receiver, "#{indent}│   "]
      end
      if (parameters = node.parameters).nil?
        commands << ["├── parameters: ∅\n", indent]
      else
        commands << ["├── parameters:\n", indent]
        commands << [parameters, "#{indent}│   "]
      end
      if (body = node.body).nil?
        commands << ["├── body: ∅\n", indent]
      else
        commands << ["├── body:\n", indent]
        commands << [body, "#{indent}│   "]
      end
      commands << ["├── locals: #{node.locals.inspect}\n", indent]
      commands << ["├── def_keyword_loc: #{inspect_location(node.def_keyword_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["├── lparen_loc: #{inspect_location(node.lparen_loc)}\n", indent]
      commands << ["├── rparen_loc: #{inspect_location(node.rparen_loc)}\n", indent]
      commands << ["├── equal_loc: #{inspect_location(node.equal_loc)}\n", indent]
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a DefinedNode node.
    def visit_defined_node(node)
      commands << [inspect_node("DefinedNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── lparen_loc: #{inspect_location(node.lparen_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["├── rparen_loc: #{inspect_location(node.rparen_loc)}\n", indent]
      commands << ["└── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
    end

    # Inspect a ElseNode node.
    def visit_else_node(node)
      commands << [inspect_node("ElseNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── else_keyword_loc: #{inspect_location(node.else_keyword_loc)}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a EmbeddedStatementsNode node.
    def visit_embedded_statements_node(node)
      commands << [inspect_node("EmbeddedStatementsNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a EmbeddedVariableNode node.
    def visit_embedded_variable_node(node)
      commands << [inspect_node("EmbeddedVariableNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── variable:\n", indent]
      commands << [node.variable, "#{indent}    "]
    end

    # Inspect a EnsureNode node.
    def visit_ensure_node(node)
      commands << [inspect_node("EnsureNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── ensure_keyword_loc: #{inspect_location(node.ensure_keyword_loc)}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a FalseNode node.
    def visit_false_node(node)
      commands << [inspect_node("FalseNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a FindPatternNode node.
    def visit_find_pattern_node(node)
      commands << [inspect_node("FindPatternNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (constant = node.constant).nil?
        commands << ["├── constant: ∅\n", indent]
      else
        commands << ["├── constant:\n", indent]
        commands << [constant, "#{indent}│   "]
      end
      commands << ["├── left:\n", indent]
      commands << [node.left, "#{indent}│   "]
      commands << ["├── requireds: (length: #{(requireds = node.requireds).length})\n", indent]
      if requireds.any?
        requireds[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [requireds[-1], "#{indent}│       "]
      end
      commands << ["├── right:\n", indent]
      commands << [node.right, "#{indent}│   "]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a FlipFlopNode node.
    def visit_flip_flop_node(node)
      commands << [inspect_node("FlipFlopNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("exclude_end" if node.exclude_end?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (left = node.left).nil?
        commands << ["├── left: ∅\n", indent]
      else
        commands << ["├── left:\n", indent]
        commands << [left, "#{indent}│   "]
      end
      if (right = node.right).nil?
        commands << ["├── right: ∅\n", indent]
      else
        commands << ["├── right:\n", indent]
        commands << [right, "#{indent}│   "]
      end
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a FloatNode node.
    def visit_float_node(node)
      commands << [inspect_node("FloatNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── value: #{node.value.inspect}\n", indent]
    end

    # Inspect a ForNode node.
    def visit_for_node(node)
      commands << [inspect_node("ForNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── index:\n", indent]
      commands << [node.index, "#{indent}│   "]
      commands << ["├── collection:\n", indent]
      commands << [node.collection, "#{indent}│   "]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      commands << ["├── for_keyword_loc: #{inspect_location(node.for_keyword_loc)}\n", indent]
      commands << ["├── in_keyword_loc: #{inspect_location(node.in_keyword_loc)}\n", indent]
      commands << ["├── do_keyword_loc: #{inspect_location(node.do_keyword_loc)}\n", indent]
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a ForwardingArgumentsNode node.
    def visit_forwarding_arguments_node(node)
      commands << [inspect_node("ForwardingArgumentsNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a ForwardingParameterNode node.
    def visit_forwarding_parameter_node(node)
      commands << [inspect_node("ForwardingParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a ForwardingSuperNode node.
    def visit_forwarding_super_node(node)
      commands << [inspect_node("ForwardingSuperNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (block = node.block).nil?
        commands << ["└── block: ∅\n", indent]
      else
        commands << ["└── block:\n", indent]
        commands << [block, "#{indent}    "]
      end
    end

    # Inspect a GlobalVariableAndWriteNode node.
    def visit_global_variable_and_write_node(node)
      commands << [inspect_node("GlobalVariableAndWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a GlobalVariableOperatorWriteNode node.
    def visit_global_variable_operator_write_node(node)
      commands << [inspect_node("GlobalVariableOperatorWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── binary_operator_loc: #{inspect_location(node.binary_operator_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── binary_operator: #{node.binary_operator.inspect}\n", indent]
    end

    # Inspect a GlobalVariableOrWriteNode node.
    def visit_global_variable_or_write_node(node)
      commands << [inspect_node("GlobalVariableOrWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a GlobalVariableReadNode node.
    def visit_global_variable_read_node(node)
      commands << [inspect_node("GlobalVariableReadNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a GlobalVariableTargetNode node.
    def visit_global_variable_target_node(node)
      commands << [inspect_node("GlobalVariableTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a GlobalVariableWriteNode node.
    def visit_global_variable_write_node(node)
      commands << [inspect_node("GlobalVariableWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a HashNode node.
    def visit_hash_node(node)
      commands << [inspect_node("HashNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── elements: (length: #{(elements = node.elements).length})\n", indent]
      if elements.any?
        elements[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [elements[-1], "#{indent}│       "]
      end
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a HashPatternNode node.
    def visit_hash_pattern_node(node)
      commands << [inspect_node("HashPatternNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (constant = node.constant).nil?
        commands << ["├── constant: ∅\n", indent]
      else
        commands << ["├── constant:\n", indent]
        commands << [constant, "#{indent}│   "]
      end
      commands << ["├── elements: (length: #{(elements = node.elements).length})\n", indent]
      if elements.any?
        elements[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [elements[-1], "#{indent}│       "]
      end
      if (rest = node.rest).nil?
        commands << ["├── rest: ∅\n", indent]
      else
        commands << ["├── rest:\n", indent]
        commands << [rest, "#{indent}│   "]
      end
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a IfNode node.
    def visit_if_node(node)
      commands << [inspect_node("IfNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── if_keyword_loc: #{inspect_location(node.if_keyword_loc)}\n", indent]
      commands << ["├── predicate:\n", indent]
      commands << [node.predicate, "#{indent}│   "]
      commands << ["├── then_keyword_loc: #{inspect_location(node.then_keyword_loc)}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      if (subsequent = node.subsequent).nil?
        commands << ["├── subsequent: ∅\n", indent]
      else
        commands << ["├── subsequent:\n", indent]
        commands << [subsequent, "#{indent}│   "]
      end
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a ImaginaryNode node.
    def visit_imaginary_node(node)
      commands << [inspect_node("ImaginaryNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── numeric:\n", indent]
      commands << [node.numeric, "#{indent}    "]
    end

    # Inspect a ImplicitNode node.
    def visit_implicit_node(node)
      commands << [inspect_node("ImplicitNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a ImplicitRestNode node.
    def visit_implicit_rest_node(node)
      commands << [inspect_node("ImplicitRestNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a InNode node.
    def visit_in_node(node)
      commands << [inspect_node("InNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── pattern:\n", indent]
      commands << [node.pattern, "#{indent}│   "]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      commands << ["├── in_loc: #{inspect_location(node.in_loc)}\n", indent]
      commands << ["└── then_loc: #{inspect_location(node.then_loc)}\n", indent]
    end

    # Inspect a IndexAndWriteNode node.
    def visit_index_and_write_node(node)
      commands << [inspect_node("IndexAndWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (receiver = node.receiver).nil?
        commands << ["├── receiver: ∅\n", indent]
      else
        commands << ["├── receiver:\n", indent]
        commands << [receiver, "#{indent}│   "]
      end
      commands << ["├── call_operator_loc: #{inspect_location(node.call_operator_loc)}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      if (block = node.block).nil?
        commands << ["├── block: ∅\n", indent]
      else
        commands << ["├── block:\n", indent]
        commands << [block, "#{indent}│   "]
      end
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a IndexOperatorWriteNode node.
    def visit_index_operator_write_node(node)
      commands << [inspect_node("IndexOperatorWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (receiver = node.receiver).nil?
        commands << ["├── receiver: ∅\n", indent]
      else
        commands << ["├── receiver:\n", indent]
        commands << [receiver, "#{indent}│   "]
      end
      commands << ["├── call_operator_loc: #{inspect_location(node.call_operator_loc)}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      if (block = node.block).nil?
        commands << ["├── block: ∅\n", indent]
      else
        commands << ["├── block:\n", indent]
        commands << [block, "#{indent}│   "]
      end
      commands << ["├── binary_operator: #{node.binary_operator.inspect}\n", indent]
      commands << ["├── binary_operator_loc: #{inspect_location(node.binary_operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a IndexOrWriteNode node.
    def visit_index_or_write_node(node)
      commands << [inspect_node("IndexOrWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (receiver = node.receiver).nil?
        commands << ["├── receiver: ∅\n", indent]
      else
        commands << ["├── receiver:\n", indent]
        commands << [receiver, "#{indent}│   "]
      end
      commands << ["├── call_operator_loc: #{inspect_location(node.call_operator_loc)}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      if (block = node.block).nil?
        commands << ["├── block: ∅\n", indent]
      else
        commands << ["├── block:\n", indent]
        commands << [block, "#{indent}│   "]
      end
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a IndexTargetNode node.
    def visit_index_target_node(node)
      commands << [inspect_node("IndexTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("safe_navigation" if node.safe_navigation?), ("variable_call" if node.variable_call?), ("attribute_write" if node.attribute_write?), ("ignore_visibility" if node.ignore_visibility?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── receiver:\n", indent]
      commands << [node.receiver, "#{indent}│   "]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      if (block = node.block).nil?
        commands << ["└── block: ∅\n", indent]
      else
        commands << ["└── block:\n", indent]
        commands << [block, "#{indent}    "]
      end
    end

    # Inspect a InstanceVariableAndWriteNode node.
    def visit_instance_variable_and_write_node(node)
      commands << [inspect_node("InstanceVariableAndWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a InstanceVariableOperatorWriteNode node.
    def visit_instance_variable_operator_write_node(node)
      commands << [inspect_node("InstanceVariableOperatorWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── binary_operator_loc: #{inspect_location(node.binary_operator_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── binary_operator: #{node.binary_operator.inspect}\n", indent]
    end

    # Inspect a InstanceVariableOrWriteNode node.
    def visit_instance_variable_or_write_node(node)
      commands << [inspect_node("InstanceVariableOrWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a InstanceVariableReadNode node.
    def visit_instance_variable_read_node(node)
      commands << [inspect_node("InstanceVariableReadNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a InstanceVariableTargetNode node.
    def visit_instance_variable_target_node(node)
      commands << [inspect_node("InstanceVariableTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a InstanceVariableWriteNode node.
    def visit_instance_variable_write_node(node)
      commands << [inspect_node("InstanceVariableWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a IntegerNode node.
    def visit_integer_node(node)
      commands << [inspect_node("IntegerNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("binary" if node.binary?), ("decimal" if node.decimal?), ("octal" if node.octal?), ("hexadecimal" if node.hexadecimal?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── value: #{node.value.inspect}\n", indent]
    end

    # Inspect a InterpolatedMatchLastLineNode node.
    def visit_interpolated_match_last_line_node(node)
      commands << [inspect_node("InterpolatedMatchLastLineNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("ignore_case" if node.ignore_case?), ("extended" if node.extended?), ("multi_line" if node.multi_line?), ("once" if node.once?), ("euc_jp" if node.euc_jp?), ("ascii_8bit" if node.ascii_8bit?), ("windows_31j" if node.windows_31j?), ("utf_8" if node.utf_8?), ("forced_utf8_encoding" if node.forced_utf8_encoding?), ("forced_binary_encoding" if node.forced_binary_encoding?), ("forced_us_ascii_encoding" if node.forced_us_ascii_encoding?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── parts: (length: #{(parts = node.parts).length})\n", indent]
      if parts.any?
        parts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [parts[-1], "#{indent}│       "]
      end
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a InterpolatedRegularExpressionNode node.
    def visit_interpolated_regular_expression_node(node)
      commands << [inspect_node("InterpolatedRegularExpressionNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("ignore_case" if node.ignore_case?), ("extended" if node.extended?), ("multi_line" if node.multi_line?), ("once" if node.once?), ("euc_jp" if node.euc_jp?), ("ascii_8bit" if node.ascii_8bit?), ("windows_31j" if node.windows_31j?), ("utf_8" if node.utf_8?), ("forced_utf8_encoding" if node.forced_utf8_encoding?), ("forced_binary_encoding" if node.forced_binary_encoding?), ("forced_us_ascii_encoding" if node.forced_us_ascii_encoding?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── parts: (length: #{(parts = node.parts).length})\n", indent]
      if parts.any?
        parts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [parts[-1], "#{indent}│       "]
      end
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a InterpolatedStringNode node.
    def visit_interpolated_string_node(node)
      commands << [inspect_node("InterpolatedStringNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("frozen" if node.frozen?), ("mutable" if node.mutable?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── parts: (length: #{(parts = node.parts).length})\n", indent]
      if parts.any?
        parts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [parts[-1], "#{indent}│       "]
      end
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a InterpolatedSymbolNode node.
    def visit_interpolated_symbol_node(node)
      commands << [inspect_node("InterpolatedSymbolNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── parts: (length: #{(parts = node.parts).length})\n", indent]
      if parts.any?
        parts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [parts[-1], "#{indent}│       "]
      end
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a InterpolatedXStringNode node.
    def visit_interpolated_x_string_node(node)
      commands << [inspect_node("InterpolatedXStringNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── parts: (length: #{(parts = node.parts).length})\n", indent]
      if parts.any?
        parts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [parts[-1], "#{indent}│       "]
      end
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a ItLocalVariableReadNode node.
    def visit_it_local_variable_read_node(node)
      commands << [inspect_node("ItLocalVariableReadNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a ItParametersNode node.
    def visit_it_parameters_node(node)
      commands << [inspect_node("ItParametersNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a KeywordHashNode node.
    def visit_keyword_hash_node(node)
      commands << [inspect_node("KeywordHashNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("symbol_keys" if node.symbol_keys?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── elements: (length: #{(elements = node.elements).length})\n", indent]
      if elements.any?
        elements[0...-1].each do |child|
          commands << [Replace.new("#{indent}    ├── "), indent]
          commands << [child, "#{indent}    │   "]
        end
        commands << [Replace.new("#{indent}    └── "), indent]
        commands << [elements[-1], "#{indent}        "]
      end
    end

    # Inspect a KeywordRestParameterNode node.
    def visit_keyword_rest_parameter_node(node)
      commands << [inspect_node("KeywordRestParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("repeated_parameter" if node.repeated_parameter?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (name = node.name).nil?
        commands << ["├── name: ∅\n", indent]
      else
        commands << ["├── name: #{name.inspect}\n", indent]
      end
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a LambdaNode node.
    def visit_lambda_node(node)
      commands << [inspect_node("LambdaNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── locals: #{node.locals.inspect}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      if (parameters = node.parameters).nil?
        commands << ["├── parameters: ∅\n", indent]
      else
        commands << ["├── parameters:\n", indent]
        commands << [parameters, "#{indent}│   "]
      end
      if (body = node.body).nil?
        commands << ["└── body: ∅\n", indent]
      else
        commands << ["└── body:\n", indent]
        commands << [body, "#{indent}    "]
      end
    end

    # Inspect a LocalVariableAndWriteNode node.
    def visit_local_variable_and_write_node(node)
      commands << [inspect_node("LocalVariableAndWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["└── depth: #{node.depth.inspect}\n", indent]
    end

    # Inspect a LocalVariableOperatorWriteNode node.
    def visit_local_variable_operator_write_node(node)
      commands << [inspect_node("LocalVariableOperatorWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── binary_operator_loc: #{inspect_location(node.binary_operator_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── binary_operator: #{node.binary_operator.inspect}\n", indent]
      commands << ["└── depth: #{node.depth.inspect}\n", indent]
    end

    # Inspect a LocalVariableOrWriteNode node.
    def visit_local_variable_or_write_node(node)
      commands << [inspect_node("LocalVariableOrWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["└── depth: #{node.depth.inspect}\n", indent]
    end

    # Inspect a LocalVariableReadNode node.
    def visit_local_variable_read_node(node)
      commands << [inspect_node("LocalVariableReadNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["└── depth: #{node.depth.inspect}\n", indent]
    end

    # Inspect a LocalVariableTargetNode node.
    def visit_local_variable_target_node(node)
      commands << [inspect_node("LocalVariableTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["└── depth: #{node.depth.inspect}\n", indent]
    end

    # Inspect a LocalVariableWriteNode node.
    def visit_local_variable_write_node(node)
      commands << [inspect_node("LocalVariableWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── depth: #{node.depth.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a MatchLastLineNode node.
    def visit_match_last_line_node(node)
      commands << [inspect_node("MatchLastLineNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("ignore_case" if node.ignore_case?), ("extended" if node.extended?), ("multi_line" if node.multi_line?), ("once" if node.once?), ("euc_jp" if node.euc_jp?), ("ascii_8bit" if node.ascii_8bit?), ("windows_31j" if node.windows_31j?), ("utf_8" if node.utf_8?), ("forced_utf8_encoding" if node.forced_utf8_encoding?), ("forced_binary_encoding" if node.forced_binary_encoding?), ("forced_us_ascii_encoding" if node.forced_us_ascii_encoding?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── content_loc: #{inspect_location(node.content_loc)}\n", indent]
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      commands << ["└── unescaped: #{node.unescaped.inspect}\n", indent]
    end

    # Inspect a MatchPredicateNode node.
    def visit_match_predicate_node(node)
      commands << [inspect_node("MatchPredicateNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["├── pattern:\n", indent]
      commands << [node.pattern, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a MatchRequiredNode node.
    def visit_match_required_node(node)
      commands << [inspect_node("MatchRequiredNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── value:\n", indent]
      commands << [node.value, "#{indent}│   "]
      commands << ["├── pattern:\n", indent]
      commands << [node.pattern, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a MatchWriteNode node.
    def visit_match_write_node(node)
      commands << [inspect_node("MatchWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── call:\n", indent]
      commands << [node.call, "#{indent}│   "]
      commands << ["└── targets: (length: #{(targets = node.targets).length})\n", indent]
      if targets.any?
        targets[0...-1].each do |child|
          commands << [Replace.new("#{indent}    ├── "), indent]
          commands << [child, "#{indent}    │   "]
        end
        commands << [Replace.new("#{indent}    └── "), indent]
        commands << [targets[-1], "#{indent}        "]
      end
    end

    # Inspect a MissingNode node.
    def visit_missing_node(node)
      commands << [inspect_node("MissingNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a ModuleNode node.
    def visit_module_node(node)
      commands << [inspect_node("ModuleNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── locals: #{node.locals.inspect}\n", indent]
      commands << ["├── module_keyword_loc: #{inspect_location(node.module_keyword_loc)}\n", indent]
      commands << ["├── constant_path:\n", indent]
      commands << [node.constant_path, "#{indent}│   "]
      if (body = node.body).nil?
        commands << ["├── body: ∅\n", indent]
      else
        commands << ["├── body:\n", indent]
        commands << [body, "#{indent}│   "]
      end
      commands << ["├── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a MultiTargetNode node.
    def visit_multi_target_node(node)
      commands << [inspect_node("MultiTargetNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── lefts: (length: #{(lefts = node.lefts).length})\n", indent]
      if lefts.any?
        lefts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [lefts[-1], "#{indent}│       "]
      end
      if (rest = node.rest).nil?
        commands << ["├── rest: ∅\n", indent]
      else
        commands << ["├── rest:\n", indent]
        commands << [rest, "#{indent}│   "]
      end
      commands << ["├── rights: (length: #{(rights = node.rights).length})\n", indent]
      if rights.any?
        rights[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [rights[-1], "#{indent}│       "]
      end
      commands << ["├── lparen_loc: #{inspect_location(node.lparen_loc)}\n", indent]
      commands << ["└── rparen_loc: #{inspect_location(node.rparen_loc)}\n", indent]
    end

    # Inspect a MultiWriteNode node.
    def visit_multi_write_node(node)
      commands << [inspect_node("MultiWriteNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── lefts: (length: #{(lefts = node.lefts).length})\n", indent]
      if lefts.any?
        lefts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [lefts[-1], "#{indent}│       "]
      end
      if (rest = node.rest).nil?
        commands << ["├── rest: ∅\n", indent]
      else
        commands << ["├── rest:\n", indent]
        commands << [rest, "#{indent}│   "]
      end
      commands << ["├── rights: (length: #{(rights = node.rights).length})\n", indent]
      if rights.any?
        rights[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [rights[-1], "#{indent}│       "]
      end
      commands << ["├── lparen_loc: #{inspect_location(node.lparen_loc)}\n", indent]
      commands << ["├── rparen_loc: #{inspect_location(node.rparen_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a NextNode node.
    def visit_next_node(node)
      commands << [inspect_node("NextNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["└── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
    end

    # Inspect a NilNode node.
    def visit_nil_node(node)
      commands << [inspect_node("NilNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a NoKeywordsParameterNode node.
    def visit_no_keywords_parameter_node(node)
      commands << [inspect_node("NoKeywordsParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
    end

    # Inspect a NumberedParametersNode node.
    def visit_numbered_parameters_node(node)
      commands << [inspect_node("NumberedParametersNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── maximum: #{node.maximum.inspect}\n", indent]
    end

    # Inspect a NumberedReferenceReadNode node.
    def visit_numbered_reference_read_node(node)
      commands << [inspect_node("NumberedReferenceReadNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── number: #{node.number.inspect}\n", indent]
    end

    # Inspect a OptionalKeywordParameterNode node.
    def visit_optional_keyword_parameter_node(node)
      commands << [inspect_node("OptionalKeywordParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("repeated_parameter" if node.repeated_parameter?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a OptionalParameterNode node.
    def visit_optional_parameter_node(node)
      commands << [inspect_node("OptionalParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("repeated_parameter" if node.repeated_parameter?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["└── value:\n", indent]
      commands << [node.value, "#{indent}    "]
    end

    # Inspect a OrNode node.
    def visit_or_node(node)
      commands << [inspect_node("OrNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── left:\n", indent]
      commands << [node.left, "#{indent}│   "]
      commands << ["├── right:\n", indent]
      commands << [node.right, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a ParametersNode node.
    def visit_parameters_node(node)
      commands << [inspect_node("ParametersNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── requireds: (length: #{(requireds = node.requireds).length})\n", indent]
      if requireds.any?
        requireds[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [requireds[-1], "#{indent}│       "]
      end
      commands << ["├── optionals: (length: #{(optionals = node.optionals).length})\n", indent]
      if optionals.any?
        optionals[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [optionals[-1], "#{indent}│       "]
      end
      if (rest = node.rest).nil?
        commands << ["├── rest: ∅\n", indent]
      else
        commands << ["├── rest:\n", indent]
        commands << [rest, "#{indent}│   "]
      end
      commands << ["├── posts: (length: #{(posts = node.posts).length})\n", indent]
      if posts.any?
        posts[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [posts[-1], "#{indent}│       "]
      end
      commands << ["├── keywords: (length: #{(keywords = node.keywords).length})\n", indent]
      if keywords.any?
        keywords[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [keywords[-1], "#{indent}│       "]
      end
      if (keyword_rest = node.keyword_rest).nil?
        commands << ["├── keyword_rest: ∅\n", indent]
      else
        commands << ["├── keyword_rest:\n", indent]
        commands << [keyword_rest, "#{indent}│   "]
      end
      if (block = node.block).nil?
        commands << ["└── block: ∅\n", indent]
      else
        commands << ["└── block:\n", indent]
        commands << [block, "#{indent}    "]
      end
    end

    # Inspect a ParenthesesNode node.
    def visit_parentheses_node(node)
      commands << [inspect_node("ParenthesesNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("multiple_statements" if node.multiple_statements?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (body = node.body).nil?
        commands << ["├── body: ∅\n", indent]
      else
        commands << ["├── body:\n", indent]
        commands << [body, "#{indent}│   "]
      end
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a PinnedExpressionNode node.
    def visit_pinned_expression_node(node)
      commands << [inspect_node("PinnedExpressionNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── expression:\n", indent]
      commands << [node.expression, "#{indent}│   "]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["├── lparen_loc: #{inspect_location(node.lparen_loc)}\n", indent]
      commands << ["└── rparen_loc: #{inspect_location(node.rparen_loc)}\n", indent]
    end

    # Inspect a PinnedVariableNode node.
    def visit_pinned_variable_node(node)
      commands << [inspect_node("PinnedVariableNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── variable:\n", indent]
      commands << [node.variable, "#{indent}│   "]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a PostExecutionNode node.
    def visit_post_execution_node(node)
      commands << [inspect_node("PostExecutionNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a PreExecutionNode node.
    def visit_pre_execution_node(node)
      commands << [inspect_node("PreExecutionNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["└── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
    end

    # Inspect a ProgramNode node.
    def visit_program_node(node)
      commands << [inspect_node("ProgramNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── locals: #{node.locals.inspect}\n", indent]
      commands << ["└── statements:\n", indent]
      commands << [node.statements, "#{indent}    "]
    end

    # Inspect a RangeNode node.
    def visit_range_node(node)
      commands << [inspect_node("RangeNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("exclude_end" if node.exclude_end?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (left = node.left).nil?
        commands << ["├── left: ∅\n", indent]
      else
        commands << ["├── left:\n", indent]
        commands << [left, "#{indent}│   "]
      end
      if (right = node.right).nil?
        commands << ["├── right: ∅\n", indent]
      else
        commands << ["├── right:\n", indent]
        commands << [right, "#{indent}│   "]
      end
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a RationalNode node.
    def visit_rational_node(node)
      commands << [inspect_node("RationalNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("binary" if node.binary?), ("decimal" if node.decimal?), ("octal" if node.octal?), ("hexadecimal" if node.hexadecimal?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── numerator: #{node.numerator.inspect}\n", indent]
      commands << ["└── denominator: #{node.denominator.inspect}\n", indent]
    end

    # Inspect a RedoNode node.
    def visit_redo_node(node)
      commands << [inspect_node("RedoNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a RegularExpressionNode node.
    def visit_regular_expression_node(node)
      commands << [inspect_node("RegularExpressionNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("ignore_case" if node.ignore_case?), ("extended" if node.extended?), ("multi_line" if node.multi_line?), ("once" if node.once?), ("euc_jp" if node.euc_jp?), ("ascii_8bit" if node.ascii_8bit?), ("windows_31j" if node.windows_31j?), ("utf_8" if node.utf_8?), ("forced_utf8_encoding" if node.forced_utf8_encoding?), ("forced_binary_encoding" if node.forced_binary_encoding?), ("forced_us_ascii_encoding" if node.forced_us_ascii_encoding?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── content_loc: #{inspect_location(node.content_loc)}\n", indent]
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      commands << ["└── unescaped: #{node.unescaped.inspect}\n", indent]
    end

    # Inspect a RequiredKeywordParameterNode node.
    def visit_required_keyword_parameter_node(node)
      commands << [inspect_node("RequiredKeywordParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("repeated_parameter" if node.repeated_parameter?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── name: #{node.name.inspect}\n", indent]
      commands << ["└── name_loc: #{inspect_location(node.name_loc)}\n", indent]
    end

    # Inspect a RequiredParameterNode node.
    def visit_required_parameter_node(node)
      commands << [inspect_node("RequiredParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("repeated_parameter" if node.repeated_parameter?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── name: #{node.name.inspect}\n", indent]
    end

    # Inspect a RescueModifierNode node.
    def visit_rescue_modifier_node(node)
      commands << [inspect_node("RescueModifierNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── expression:\n", indent]
      commands << [node.expression, "#{indent}│   "]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["└── rescue_expression:\n", indent]
      commands << [node.rescue_expression, "#{indent}    "]
    end

    # Inspect a RescueNode node.
    def visit_rescue_node(node)
      commands << [inspect_node("RescueNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── exceptions: (length: #{(exceptions = node.exceptions).length})\n", indent]
      if exceptions.any?
        exceptions[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [exceptions[-1], "#{indent}│       "]
      end
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      if (reference = node.reference).nil?
        commands << ["├── reference: ∅\n", indent]
      else
        commands << ["├── reference:\n", indent]
        commands << [reference, "#{indent}│   "]
      end
      commands << ["├── then_keyword_loc: #{inspect_location(node.then_keyword_loc)}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      if (subsequent = node.subsequent).nil?
        commands << ["└── subsequent: ∅\n", indent]
      else
        commands << ["└── subsequent:\n", indent]
        commands << [subsequent, "#{indent}    "]
      end
    end

    # Inspect a RestParameterNode node.
    def visit_rest_parameter_node(node)
      commands << [inspect_node("RestParameterNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("repeated_parameter" if node.repeated_parameter?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      if (name = node.name).nil?
        commands << ["├── name: ∅\n", indent]
      else
        commands << ["├── name: #{name.inspect}\n", indent]
      end
      commands << ["├── name_loc: #{inspect_location(node.name_loc)}\n", indent]
      commands << ["└── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
    end

    # Inspect a RetryNode node.
    def visit_retry_node(node)
      commands << [inspect_node("RetryNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a ReturnNode node.
    def visit_return_node(node)
      commands << [inspect_node("ReturnNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["└── arguments: ∅\n", indent]
      else
        commands << ["└── arguments:\n", indent]
        commands << [arguments, "#{indent}    "]
      end
    end

    # Inspect a SelfNode node.
    def visit_self_node(node)
      commands << [inspect_node("SelfNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a ShareableConstantNode node.
    def visit_shareable_constant_node(node)
      commands << [inspect_node("ShareableConstantNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("literal" if node.literal?), ("experimental_everything" if node.experimental_everything?), ("experimental_copy" if node.experimental_copy?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── write:\n", indent]
      commands << [node.write, "#{indent}    "]
    end

    # Inspect a SingletonClassNode node.
    def visit_singleton_class_node(node)
      commands << [inspect_node("SingletonClassNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── locals: #{node.locals.inspect}\n", indent]
      commands << ["├── class_keyword_loc: #{inspect_location(node.class_keyword_loc)}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      commands << ["├── expression:\n", indent]
      commands << [node.expression, "#{indent}│   "]
      if (body = node.body).nil?
        commands << ["├── body: ∅\n", indent]
      else
        commands << ["├── body:\n", indent]
        commands << [body, "#{indent}│   "]
      end
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a SourceEncodingNode node.
    def visit_source_encoding_node(node)
      commands << [inspect_node("SourceEncodingNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a SourceFileNode node.
    def visit_source_file_node(node)
      commands << [inspect_node("SourceFileNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("forced_utf8_encoding" if node.forced_utf8_encoding?), ("forced_binary_encoding" if node.forced_binary_encoding?), ("frozen" if node.frozen?), ("mutable" if node.mutable?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── filepath: #{node.filepath.inspect}\n", indent]
    end

    # Inspect a SourceLineNode node.
    def visit_source_line_node(node)
      commands << [inspect_node("SourceLineNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a SplatNode node.
    def visit_splat_node(node)
      commands << [inspect_node("SplatNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── operator_loc: #{inspect_location(node.operator_loc)}\n", indent]
      if (expression = node.expression).nil?
        commands << ["└── expression: ∅\n", indent]
      else
        commands << ["└── expression:\n", indent]
        commands << [expression, "#{indent}    "]
      end
    end

    # Inspect a StatementsNode node.
    def visit_statements_node(node)
      commands << [inspect_node("StatementsNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["└── body: (length: #{(body = node.body).length})\n", indent]
      if body.any?
        body[0...-1].each do |child|
          commands << [Replace.new("#{indent}    ├── "), indent]
          commands << [child, "#{indent}    │   "]
        end
        commands << [Replace.new("#{indent}    └── "), indent]
        commands << [body[-1], "#{indent}        "]
      end
    end

    # Inspect a StringNode node.
    def visit_string_node(node)
      commands << [inspect_node("StringNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("forced_utf8_encoding" if node.forced_utf8_encoding?), ("forced_binary_encoding" if node.forced_binary_encoding?), ("frozen" if node.frozen?), ("mutable" if node.mutable?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── content_loc: #{inspect_location(node.content_loc)}\n", indent]
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      commands << ["└── unescaped: #{node.unescaped.inspect}\n", indent]
    end

    # Inspect a SuperNode node.
    def visit_super_node(node)
      commands << [inspect_node("SuperNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── lparen_loc: #{inspect_location(node.lparen_loc)}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["├── rparen_loc: #{inspect_location(node.rparen_loc)}\n", indent]
      if (block = node.block).nil?
        commands << ["└── block: ∅\n", indent]
      else
        commands << ["└── block:\n", indent]
        commands << [block, "#{indent}    "]
      end
    end

    # Inspect a SymbolNode node.
    def visit_symbol_node(node)
      commands << [inspect_node("SymbolNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("forced_utf8_encoding" if node.forced_utf8_encoding?), ("forced_binary_encoding" if node.forced_binary_encoding?), ("forced_us_ascii_encoding" if node.forced_us_ascii_encoding?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── value_loc: #{inspect_location(node.value_loc)}\n", indent]
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      commands << ["└── unescaped: #{node.unescaped.inspect}\n", indent]
    end

    # Inspect a TrueNode node.
    def visit_true_node(node)
      commands << [inspect_node("TrueNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["└── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
    end

    # Inspect a UndefNode node.
    def visit_undef_node(node)
      commands << [inspect_node("UndefNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── names: (length: #{(names = node.names).length})\n", indent]
      if names.any?
        names[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [names[-1], "#{indent}│       "]
      end
      commands << ["└── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
    end

    # Inspect a UnlessNode node.
    def visit_unless_node(node)
      commands << [inspect_node("UnlessNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── predicate:\n", indent]
      commands << [node.predicate, "#{indent}│   "]
      commands << ["├── then_keyword_loc: #{inspect_location(node.then_keyword_loc)}\n", indent]
      if (statements = node.statements).nil?
        commands << ["├── statements: ∅\n", indent]
      else
        commands << ["├── statements:\n", indent]
        commands << [statements, "#{indent}│   "]
      end
      if (else_clause = node.else_clause).nil?
        commands << ["├── else_clause: ∅\n", indent]
      else
        commands << ["├── else_clause:\n", indent]
        commands << [else_clause, "#{indent}│   "]
      end
      commands << ["└── end_keyword_loc: #{inspect_location(node.end_keyword_loc)}\n", indent]
    end

    # Inspect a UntilNode node.
    def visit_until_node(node)
      commands << [inspect_node("UntilNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("begin_modifier" if node.begin_modifier?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── do_keyword_loc: #{inspect_location(node.do_keyword_loc)}\n", indent]
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      commands << ["├── predicate:\n", indent]
      commands << [node.predicate, "#{indent}│   "]
      if (statements = node.statements).nil?
        commands << ["└── statements: ∅\n", indent]
      else
        commands << ["└── statements:\n", indent]
        commands << [statements, "#{indent}    "]
      end
    end

    # Inspect a WhenNode node.
    def visit_when_node(node)
      commands << [inspect_node("WhenNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── conditions: (length: #{(conditions = node.conditions).length})\n", indent]
      if conditions.any?
        conditions[0...-1].each do |child|
          commands << [Replace.new("#{indent}│   ├── "), indent]
          commands << [child, "#{indent}│   │   "]
        end
        commands << [Replace.new("#{indent}│   └── "), indent]
        commands << [conditions[-1], "#{indent}│       "]
      end
      commands << ["├── then_keyword_loc: #{inspect_location(node.then_keyword_loc)}\n", indent]
      if (statements = node.statements).nil?
        commands << ["└── statements: ∅\n", indent]
      else
        commands << ["└── statements:\n", indent]
        commands << [statements, "#{indent}    "]
      end
    end

    # Inspect a WhileNode node.
    def visit_while_node(node)
      commands << [inspect_node("WhileNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("begin_modifier" if node.begin_modifier?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── do_keyword_loc: #{inspect_location(node.do_keyword_loc)}\n", indent]
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      commands << ["├── predicate:\n", indent]
      commands << [node.predicate, "#{indent}│   "]
      if (statements = node.statements).nil?
        commands << ["└── statements: ∅\n", indent]
      else
        commands << ["└── statements:\n", indent]
        commands << [statements, "#{indent}    "]
      end
    end

    # Inspect a XStringNode node.
    def visit_x_string_node(node)
      commands << [inspect_node("XStringNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ("forced_utf8_encoding" if node.forced_utf8_encoding?), ("forced_binary_encoding" if node.forced_binary_encoding?)].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── opening_loc: #{inspect_location(node.opening_loc)}\n", indent]
      commands << ["├── content_loc: #{inspect_location(node.content_loc)}\n", indent]
      commands << ["├── closing_loc: #{inspect_location(node.closing_loc)}\n", indent]
      commands << ["└── unescaped: #{node.unescaped.inspect}\n", indent]
    end

    # Inspect a YieldNode node.
    def visit_yield_node(node)
      commands << [inspect_node("YieldNode", node), indent]
      flags = [("newline" if node.newline?), ("static_literal" if node.static_literal?), ].compact
      commands << ["├── flags: #{flags.empty? ? "∅" : flags.join(", ")}\n", indent]
      commands << ["├── keyword_loc: #{inspect_location(node.keyword_loc)}\n", indent]
      commands << ["├── lparen_loc: #{inspect_location(node.lparen_loc)}\n", indent]
      if (arguments = node.arguments).nil?
        commands << ["├── arguments: ∅\n", indent]
      else
        commands << ["├── arguments:\n", indent]
        commands << [arguments, "#{indent}│   "]
      end
      commands << ["└── rparen_loc: #{inspect_location(node.rparen_loc)}\n", indent]
    end

    private

    # Compose a header for the given node.
    def inspect_node(name, node)
      location = node.location
      "@ #{name} (location: (#{location.start_line},#{location.start_column})-(#{location.end_line},#{location.end_column}))\n"
    end

    # Compose a string representing the given inner location field.
    def inspect_location(location)
      if location
        "(#{location.start_line},#{location.start_column})-(#{location.end_line},#{location.end_column}) = #{location.slice.inspect}"
      else
        "∅"
      end
    end
  end
end
