/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.knn.common.exception.KNNInvalidIndicesException;
import org.opensearch.knn.plugin.transport.KNNWarmupAction;
import org.opensearch.knn.plugin.transport.KNNWarmupRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestKNNWarmupHandler
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestKNNWarmupHandler.class);
    private static final String URL_PATH = "/warmup/{index}";
    public static String NAME = "knn_warmup_action";
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private ClusterService clusterService;

    public RestKNNWarmupHandler(Settings settings, RestController controller, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_knn/warmup/{index}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        KNNWarmupRequest knnWarmupRequest = this.createKNNWarmupRequest(request);
        logger.info("[KNN] Warmup started for the following indices: " + String.join((CharSequence)",", knnWarmupRequest.indices()));
        return channel -> client.execute((ActionType)KNNWarmupAction.INSTANCE, (ActionRequest)knnWarmupRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private KNNWarmupRequest createKNNWarmupRequest(RestRequest request) {
        String[] indexNames = StringUtils.split((String)request.param("index"), (String)",");
        Index[] indices = this.indexNameExpressionResolver.concreteIndices(this.clusterService.state(), IndicesOptions.strictExpandOpen(), indexNames);
        ArrayList<String> invalidIndexNames = new ArrayList<String>();
        Arrays.stream(indices).forEach(index -> {
            if (!"true".equals(this.clusterService.state().metadata().getIndexSafe(index).getSettings().get("index.knn"))) {
                invalidIndexNames.add(index.getName());
            }
        });
        if (invalidIndexNames.size() != 0) {
            throw new KNNInvalidIndicesException(invalidIndexNames, "Warm up request rejected. One or more indices have 'index.knn' set to false.");
        }
        return new KNNWarmupRequest(indexNames);
    }
}

