/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.mapper.dto;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.neuralsearch.util.prune.PruneType;
import org.opensearch.neuralsearch.util.prune.PruneUtils;

public class SparseEncodingConfig {
    private PruneType pruneType;
    private Float pruneRatio;

    public SparseEncodingConfig(@NonNull String name, Object value) {
        Objects.requireNonNull(name, "name is marked non-null but is null");
        if (!(value instanceof Map)) {
            throw new MapperParsingException(String.format(Locale.ROOT, "[%s] must be a Map", name));
        }
        HashMap<String, Object> config = new HashMap<String, Object>((Map)value);
        PruneType pruneType = this.consumePruneType(config);
        Float pruneRatio = this.consumePruneRatio(config);
        if (!config.isEmpty()) {
            throw new MapperParsingException(String.format(Locale.ROOT, "Unsupported parameters %s in %s", String.join((CharSequence)",", config.keySet()), name));
        }
        if (pruneType == null && pruneRatio == null) {
            return;
        }
        if (pruneRatio != null && pruneType == null | PruneType.NONE.equals((Object)pruneType)) {
            throw new MapperParsingException(String.format(Locale.ROOT, "%s should not be defined when %s is %s or null", "prune_ratio", "prune_type", PruneType.NONE.getValue()));
        }
        if (pruneRatio == null && !PruneType.NONE.equals((Object)pruneType)) {
            throw new MapperParsingException(String.format(Locale.ROOT, "%s is required when %s is defined and not %s", "prune_ratio", "prune_type", PruneType.NONE.getValue()));
        }
        if (pruneRatio == null) {
            this.pruneType = pruneType;
            return;
        }
        if (!PruneUtils.isValidPruneRatio(pruneType, pruneRatio.floatValue())) {
            throw new MapperParsingException(String.format(Locale.ROOT, "Illegal prune_ratio %f for prune_type: %s. %s", pruneRatio, pruneType.getValue(), PruneUtils.getValidPruneRatioDescription(pruneType)));
        }
        this.pruneType = pruneType;
        this.pruneRatio = pruneRatio;
    }

    public SparseEncodingConfig(@NonNull Map<String, Object> fieldConfig) {
        Objects.requireNonNull(fieldConfig, "fieldConfig is marked non-null but is null");
        if (!fieldConfig.containsKey("sparse_encoding_config")) {
            return;
        }
        Map sparseEncodingConfig = (Map)fieldConfig.get("sparse_encoding_config");
        PruneType pruneType = this.readPruneType(sparseEncodingConfig);
        Float pruneRatio = this.readPruneRatio(sparseEncodingConfig);
        if (pruneType == null && pruneRatio == null) {
            return;
        }
        this.pruneType = pruneType;
        this.pruneRatio = pruneRatio;
    }

    private Float readPruneRatio(@NonNull Map<String, Object> config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        if (config.containsKey("prune_ratio")) {
            try {
                return Float.valueOf(Float.parseFloat(config.get("prune_ratio").toString()));
            }
            catch (Exception e) {
                throw new MapperParsingException(String.format(Locale.ROOT, "[%s] must be a Float", "prune_ratio"));
            }
        }
        return null;
    }

    private Float consumePruneRatio(@NonNull Map<String, Object> config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        try {
            Float f = this.readPruneRatio(config);
            return f;
        }
        finally {
            config.remove("prune_ratio");
        }
    }

    private PruneType readPruneType(@NonNull Map<String, Object> config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        if (config.containsKey("prune_type")) {
            try {
                return PruneType.fromString((String)config.get("prune_type"));
            }
            catch (Exception e) {
                throw new MapperParsingException(String.format(Locale.ROOT, "Invalid [%s]. Valid values are [%s].", "prune_type", PruneType.getValidValues()));
            }
        }
        return null;
    }

    private PruneType consumePruneType(@NonNull Map<String, Object> config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        try {
            PruneType pruneType = this.readPruneType(config);
            return pruneType;
        }
        finally {
            config.remove("prune_type");
        }
    }

    public void toXContent(@NonNull XContentBuilder builder, String name) throws IOException {
        Objects.requireNonNull(builder, "builder is marked non-null but is null");
        builder.startObject(name);
        if (this.pruneType != null) {
            builder.field("prune_type", this.pruneType.getValue());
        }
        if (this.pruneRatio != null) {
            builder.field("prune_ratio", this.pruneRatio.floatValue());
        }
        builder.endObject();
    }

    public String toString() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (this.pruneType != null) {
            config.put("prune_type", this.pruneType.getValue());
        }
        if (this.pruneRatio != null) {
            config.put("prune_ratio", this.pruneRatio);
        }
        return ((Object)config).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            SparseEncodingConfig other = (SparseEncodingConfig)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)this.pruneType, (Object)other.pruneType);
            equalsBuilder.append((Object)this.pruneRatio, (Object)other.pruneRatio);
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.pruneType).append((Object)this.pruneRatio).toHashCode();
    }

    @Generated
    public PruneType getPruneType() {
        return this.pruneType;
    }

    @Generated
    public Float getPruneRatio() {
        return this.pruneRatio;
    }
}

