/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class NeuralKNNQuery
extends Query {
    private final Query knnQuery;
    private final String originalQueryText;

    public String toString(String field) {
        return this.knnQuery.toString(field);
    }

    public void visit(QueryVisitor visitor) {
        this.knnQuery.visit(visitor);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.knnQuery.createWeight(searcher, scoreMode, boost);
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.knnQuery.rewrite(indexSearcher);
        if (rewritten == this.knnQuery) {
            return this;
        }
        return new NeuralKNNQuery(rewritten, this.originalQueryText);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        NeuralKNNQuery that = (NeuralKNNQuery)((Object)other);
        return Objects.equals(this.knnQuery, that.knnQuery) && Objects.equals(this.originalQueryText, that.originalQueryText);
    }

    public int hashCode() {
        return Objects.hash(this.knnQuery, this.originalQueryText);
    }

    @Generated
    public Query getKnnQuery() {
        return this.knnQuery;
    }

    @Generated
    public String getOriginalQueryText() {
        return this.originalQueryText;
    }

    @Generated
    public NeuralKNNQuery(Query knnQuery, String originalQueryText) {
        this.knnQuery = knnQuery;
        this.originalQueryText = originalQueryText;
    }
}

