/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Operation;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.concurrent.AbstractParallelSearchExecutor;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.pool.PooledConnectionFactory;

public class ParallelPooledSearchExecutor
extends AbstractParallelSearchExecutor<PooledConnectionFactory> {
    public ParallelPooledSearchExecutor() {
        this(Executors.newCachedThreadPool());
    }

    public ParallelPooledSearchExecutor(ExecutorService es) {
        super(es);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Response<SearchResult>> search(PooledConnectionFactory factory, SearchFilter[] filters, String[] attrs, SearchEntryHandler ... handlers) throws LdapException {
        void var9_11;
        ExecutorCompletionService<Response<SearchResult>> searches = new ExecutorCompletionService<Response<SearchResult>>(this.getExecutorService());
        ArrayList<Future<Response<SearchResult>>> futures = new ArrayList<Future<Response<SearchResult>>>(filters.length);
        SearchFilter[] searchFilterArray = filters;
        int n = searchFilterArray.length;
        boolean bl = false;
        while (var9_11 < n) {
            SearchFilter filter = searchFilterArray[var9_11];
            SearchRequest sr = ParallelPooledSearchExecutor.newSearchRequest(this);
            if (filter != null) {
                sr.setSearchFilter(filter);
            }
            if (attrs != null) {
                sr.setReturnAttributes(attrs);
            }
            if (handlers != null) {
                sr.setSearchEntryHandlers(handlers);
            }
            Connection conn = factory.getConnection();
            SearchOperation op = this.createSearchOperation(conn);
            futures.add(searches.submit(ParallelPooledSearchExecutor.createCallable(conn, op, sr)));
            ++var9_11;
        }
        ArrayList<Response<SearchResult>> responses = new ArrayList<Response<SearchResult>>(filters.length);
        for (Future future : futures) {
            try {
                responses.add((Response<SearchResult>)future.get());
            }
            catch (ExecutionException e) {
                this.logger.debug("ExecutionException thrown, ignoring", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.logger.warn("InterruptedException thrown, ignoring", (Throwable)e);
            }
        }
        return responses;
    }

    protected static <Q extends Request, S> Callable<Response<S>> createCallable(Connection conn, Operation<Q, S> operation, Q request) {
        return () -> {
            try {
                conn.open();
                Response response = operation.execute(request);
                return response;
            }
            finally {
                conn.close();
            }
        };
    }
}

