import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog, } from "../models/models_1";
import { de_ListDistributionsByRealtimeLogConfigCommand, se_ListDistributionsByRealtimeLogConfigCommand, } from "../protocols/Aws_restXml";
export { $Command };
export class ListDistributionsByRealtimeLogConfigCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByRealtimeLogConfig", {})
    .n("CloudFrontClient", "ListDistributionsByRealtimeLogConfigCommand")
    .f(void 0, ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog)
    .ser(se_ListDistributionsByRealtimeLogConfigCommand)
    .de(de_ListDistributionsByRealtimeLogConfigCommand)
    .build() {
}
