import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { CloudFrontServiceException as __BaseException } from "./CloudFrontServiceException";
import { DistributionConfigFilterSensitiveLog, DistributionFilterSensitiveLog, } from "./models_0";
export class OriginAccessControlAlreadyExists extends __BaseException {
    name = "OriginAccessControlAlreadyExists";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "OriginAccessControlAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OriginAccessControlAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyOriginAccessControls extends __BaseException {
    name = "TooManyOriginAccessControls";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyOriginAccessControls",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyOriginAccessControls.prototype);
        this.Message = opts.Message;
    }
}
export const OriginRequestPolicyCookieBehavior = {
    all: "all",
    allExcept: "allExcept",
    none: "none",
    whitelist: "whitelist",
};
export const OriginRequestPolicyHeaderBehavior = {
    allExcept: "allExcept",
    allViewer: "allViewer",
    allViewerAndWhitelistCloudFront: "allViewerAndWhitelistCloudFront",
    none: "none",
    whitelist: "whitelist",
};
export const OriginRequestPolicyQueryStringBehavior = {
    all: "all",
    allExcept: "allExcept",
    none: "none",
    whitelist: "whitelist",
};
export class OriginRequestPolicyAlreadyExists extends __BaseException {
    name = "OriginRequestPolicyAlreadyExists";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "OriginRequestPolicyAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OriginRequestPolicyAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyCookiesInOriginRequestPolicy extends __BaseException {
    name = "TooManyCookiesInOriginRequestPolicy";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyCookiesInOriginRequestPolicy",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyCookiesInOriginRequestPolicy.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyHeadersInOriginRequestPolicy extends __BaseException {
    name = "TooManyHeadersInOriginRequestPolicy";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyHeadersInOriginRequestPolicy",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyHeadersInOriginRequestPolicy.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyOriginRequestPolicies extends __BaseException {
    name = "TooManyOriginRequestPolicies";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyOriginRequestPolicies",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyOriginRequestPolicies.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyQueryStringsInOriginRequestPolicy extends __BaseException {
    name = "TooManyQueryStringsInOriginRequestPolicy";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyQueryStringsInOriginRequestPolicy",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyQueryStringsInOriginRequestPolicy.prototype);
        this.Message = opts.Message;
    }
}
export class PublicKeyAlreadyExists extends __BaseException {
    name = "PublicKeyAlreadyExists";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "PublicKeyAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PublicKeyAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyPublicKeys extends __BaseException {
    name = "TooManyPublicKeys";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyPublicKeys",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyPublicKeys.prototype);
        this.Message = opts.Message;
    }
}
export class RealtimeLogConfigAlreadyExists extends __BaseException {
    name = "RealtimeLogConfigAlreadyExists";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "RealtimeLogConfigAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RealtimeLogConfigAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyRealtimeLogConfigs extends __BaseException {
    name = "TooManyRealtimeLogConfigs";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyRealtimeLogConfigs",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyRealtimeLogConfigs.prototype);
        this.Message = opts.Message;
    }
}
export const FrameOptionsList = {
    DENY: "DENY",
    SAMEORIGIN: "SAMEORIGIN",
};
export const ReferrerPolicyList = {
    no_referrer: "no-referrer",
    no_referrer_when_downgrade: "no-referrer-when-downgrade",
    origin: "origin",
    origin_when_cross_origin: "origin-when-cross-origin",
    same_origin: "same-origin",
    strict_origin: "strict-origin",
    strict_origin_when_cross_origin: "strict-origin-when-cross-origin",
    unsafe_url: "unsafe-url",
};
export class ResponseHeadersPolicyAlreadyExists extends __BaseException {
    name = "ResponseHeadersPolicyAlreadyExists";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResponseHeadersPolicyAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResponseHeadersPolicyAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
export class TooLongCSPInResponseHeadersPolicy extends __BaseException {
    name = "TooLongCSPInResponseHeadersPolicy";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooLongCSPInResponseHeadersPolicy",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooLongCSPInResponseHeadersPolicy.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyCustomHeadersInResponseHeadersPolicy extends __BaseException {
    name = "TooManyCustomHeadersInResponseHeadersPolicy";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyCustomHeadersInResponseHeadersPolicy",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyCustomHeadersInResponseHeadersPolicy.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyRemoveHeadersInResponseHeadersPolicy extends __BaseException {
    name = "TooManyRemoveHeadersInResponseHeadersPolicy";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyRemoveHeadersInResponseHeadersPolicy",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyRemoveHeadersInResponseHeadersPolicy.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyResponseHeadersPolicies extends __BaseException {
    name = "TooManyResponseHeadersPolicies";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyResponseHeadersPolicies",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyResponseHeadersPolicies.prototype);
        this.Message = opts.Message;
    }
}
export class StreamingDistributionAlreadyExists extends __BaseException {
    name = "StreamingDistributionAlreadyExists";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "StreamingDistributionAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StreamingDistributionAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyStreamingDistributionCNAMEs extends __BaseException {
    name = "TooManyStreamingDistributionCNAMEs";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyStreamingDistributionCNAMEs",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyStreamingDistributionCNAMEs.prototype);
        this.Message = opts.Message;
    }
}
export class TooManyStreamingDistributions extends __BaseException {
    name = "TooManyStreamingDistributions";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TooManyStreamingDistributions",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyStreamingDistributions.prototype);
        this.Message = opts.Message;
    }
}
export class IllegalDelete extends __BaseException {
    name = "IllegalDelete";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "IllegalDelete",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IllegalDelete.prototype);
        this.Message = opts.Message;
    }
}
export class CloudFrontOriginAccessIdentityInUse extends __BaseException {
    name = "CloudFrontOriginAccessIdentityInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "CloudFrontOriginAccessIdentityInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CloudFrontOriginAccessIdentityInUse.prototype);
        this.Message = opts.Message;
    }
}
export class NoSuchCloudFrontOriginAccessIdentity extends __BaseException {
    name = "NoSuchCloudFrontOriginAccessIdentity";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "NoSuchCloudFrontOriginAccessIdentity",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchCloudFrontOriginAccessIdentity.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceNotDisabled extends __BaseException {
    name = "ResourceNotDisabled";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResourceNotDisabled",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceNotDisabled.prototype);
        this.Message = opts.Message;
    }
}
export class DistributionNotDisabled extends __BaseException {
    name = "DistributionNotDisabled";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "DistributionNotDisabled",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DistributionNotDisabled.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceInUse extends __BaseException {
    name = "ResourceInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResourceInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceInUse.prototype);
        this.Message = opts.Message;
    }
}
export class FieldLevelEncryptionConfigInUse extends __BaseException {
    name = "FieldLevelEncryptionConfigInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "FieldLevelEncryptionConfigInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FieldLevelEncryptionConfigInUse.prototype);
        this.Message = opts.Message;
    }
}
export class FieldLevelEncryptionProfileInUse extends __BaseException {
    name = "FieldLevelEncryptionProfileInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "FieldLevelEncryptionProfileInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FieldLevelEncryptionProfileInUse.prototype);
        this.Message = opts.Message;
    }
}
export class FunctionInUse extends __BaseException {
    name = "FunctionInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "FunctionInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FunctionInUse.prototype);
        this.Message = opts.Message;
    }
}
export class NoSuchFunctionExists extends __BaseException {
    name = "NoSuchFunctionExists";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "NoSuchFunctionExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchFunctionExists.prototype);
        this.Message = opts.Message;
    }
}
export class NoSuchResource extends __BaseException {
    name = "NoSuchResource";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "NoSuchResource",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchResource.prototype);
        this.Message = opts.Message;
    }
}
export class NoSuchMonitoringSubscription extends __BaseException {
    name = "NoSuchMonitoringSubscription";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "NoSuchMonitoringSubscription",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchMonitoringSubscription.prototype);
        this.Message = opts.Message;
    }
}
export class NoSuchOriginAccessControl extends __BaseException {
    name = "NoSuchOriginAccessControl";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "NoSuchOriginAccessControl",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchOriginAccessControl.prototype);
        this.Message = opts.Message;
    }
}
export class OriginAccessControlInUse extends __BaseException {
    name = "OriginAccessControlInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "OriginAccessControlInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OriginAccessControlInUse.prototype);
        this.Message = opts.Message;
    }
}
export class OriginRequestPolicyInUse extends __BaseException {
    name = "OriginRequestPolicyInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "OriginRequestPolicyInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OriginRequestPolicyInUse.prototype);
        this.Message = opts.Message;
    }
}
export class PublicKeyInUse extends __BaseException {
    name = "PublicKeyInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "PublicKeyInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PublicKeyInUse.prototype);
        this.Message = opts.Message;
    }
}
export class RealtimeLogConfigInUse extends __BaseException {
    name = "RealtimeLogConfigInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "RealtimeLogConfigInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RealtimeLogConfigInUse.prototype);
        this.Message = opts.Message;
    }
}
export class ResponseHeadersPolicyInUse extends __BaseException {
    name = "ResponseHeadersPolicyInUse";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResponseHeadersPolicyInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResponseHeadersPolicyInUse.prototype);
        this.Message = opts.Message;
    }
}
export class NoSuchStreamingDistribution extends __BaseException {
    name = "NoSuchStreamingDistribution";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "NoSuchStreamingDistribution",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchStreamingDistribution.prototype);
        this.Message = opts.Message;
    }
}
export class StreamingDistributionNotDisabled extends __BaseException {
    name = "StreamingDistributionNotDisabled";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "StreamingDistributionNotDisabled",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StreamingDistributionNotDisabled.prototype);
        this.Message = opts.Message;
    }
}
export class NoSuchInvalidation extends __BaseException {
    name = "NoSuchInvalidation";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "NoSuchInvalidation",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchInvalidation.prototype);
        this.Message = opts.Message;
    }
}
export const ManagedCertificateStatus = {
    Expired: "expired",
    Failed: "failed",
    Inactive: "inactive",
    Issued: "issued",
    PendingValidation: "pending-validation",
    Revoked: "revoked",
    ValidationTimedOut: "validation-timed-out",
};
export const DistributionResourceType = {
    Distribution: "distribution",
    DistributionTenant: "distribution-tenant",
};
export const OriginRequestPolicyType = {
    custom: "custom",
    managed: "managed",
};
export const ResponseHeadersPolicyType = {
    custom: "custom",
    managed: "managed",
};
export const GetDistributionResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Distribution && { Distribution: DistributionFilterSensitiveLog(obj.Distribution) }),
});
export const GetDistributionConfigResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DistributionConfig && { DistributionConfig: DistributionConfigFilterSensitiveLog(obj.DistributionConfig) }),
});
export const GetFunctionResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FunctionCode && { FunctionCode: SENSITIVE_STRING }),
});
export const DistributionSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Comment && { Comment: SENSITIVE_STRING }),
});
export const DistributionListFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Items && { Items: obj.Items.map((item) => DistributionSummaryFilterSensitiveLog(item)) }),
});
export const ListDistributionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DistributionList && { DistributionList: DistributionListFilterSensitiveLog(obj.DistributionList) }),
});
export const ListDistributionsByAnycastIpListIdResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DistributionList && { DistributionList: DistributionListFilterSensitiveLog(obj.DistributionList) }),
});
export const ListDistributionsByConnectionModeResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DistributionList && { DistributionList: DistributionListFilterSensitiveLog(obj.DistributionList) }),
});
export const ListDistributionsByRealtimeLogConfigResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DistributionList && { DistributionList: DistributionListFilterSensitiveLog(obj.DistributionList) }),
});
export const ListDistributionsByWebACLIdResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DistributionList && { DistributionList: DistributionListFilterSensitiveLog(obj.DistributionList) }),
});
